use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum DeliveryMethodTypeView {
    
    EInvoice,
    Email,
    Kivra,
    Mail,
    Manually,
    SMS,

}


impl fmt::Display for DeliveryMethodTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}