
use crate::models::DebtorPaymentMethodView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct DebtorSelfInvoiceInfoView {
    
    #[serde(rename = "AccountNo", skip_serializing_if = "Option::is_none")]
    pub account_no: Option<String>,
    
    #[serde(rename = "ApprovedCompanyTax", skip_serializing_if = "Option::is_none")]
    pub approved_company_tax: Option<bool>,
    
    #[serde(rename = "BIC", skip_serializing_if = "Option::is_none")]
    pub bic: Option<String>,
    
    #[serde(rename = "BankgiroNo", skip_serializing_if = "Option::is_none")]
    pub bankgiro_no: Option<String>,
    
    #[serde(rename = "ClearingNo", skip_serializing_if = "Option::is_none")]
    pub clearing_no: Option<String>,
    
    #[serde(rename = "IBAN", skip_serializing_if = "Option::is_none")]
    pub iban: Option<String>,
    
    #[serde(rename = "NextSelfInvoiceNumber", skip_serializing_if = "Option::is_none")]
    pub next_self_invoice_number: Option<String>,
    
    #[serde(rename = "PaymentMethod", skip_serializing_if = "Option::is_none")]
    pub payment_method: Option<DebtorPaymentMethodView>,
    
    #[serde(rename = "PlusgiroNo", skip_serializing_if = "Option::is_none")]
    pub plusgiro_no: Option<String>,
    
}