use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum DebtorContractStateTypeView {
    
    Cancelled,
    Draft,
    Financed,
    Signed,
    Undefined,
    Unsigned,

}


impl fmt::Display for DebtorContractStateTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}