
use crate::models::DateTime; 
use crate::models::DebtCollectionActionLevelTypeView; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::InterestTypeView; 
use crate::models::LanguageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct DebtCollectionFromReconciliationInvoiceEntryView {
    
    #[serde(rename = "Address", skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    
    #[serde(rename = "Address2", skip_serializing_if = "Option::is_none")]
    pub address2: Option<String>,
    
    #[serde(rename = "Attention", skip_serializing_if = "Option::is_none")]
    pub attention: Option<String>,
    
    #[serde(rename = "CareOf", skip_serializing_if = "Option::is_none")]
    pub care_of: Option<String>,
    
    #[serde(rename = "City", skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
    
    #[serde(rename = "CommunicationLanguage", skip_serializing_if = "Option::is_none")]
    pub communication_language: Option<LanguageTypeView>,
    
    #[serde(rename = "CountryCode", skip_serializing_if = "Option::is_none")]
    pub country_code: Option<String>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "Email", skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    
    #[serde(rename = "Eviction", skip_serializing_if = "Option::is_none")]
    pub eviction: Option<bool>,
    
    #[serde(rename = "InformSocialWelfare", skip_serializing_if = "Option::is_none")]
    pub inform_social_welfare: Option<bool>,
    
    #[serde(rename = "InterestPercentage", skip_serializing_if = "Option::is_none")]
    pub interest_percentage: Option<f64>,
    
    #[serde(rename = "InterestStartInDaysAfterDueDate", skip_serializing_if = "Option::is_none")]
    pub interest_start_in_days_after_due_date: Option<i64>,
    
    #[serde(rename = "InterestType", skip_serializing_if = "Option::is_none")]
    pub interest_type: Option<InterestTypeView>,
    
    #[serde(rename = "NumberOfReminders", skip_serializing_if = "Option::is_none")]
    pub number_of_reminders: Option<i64>,
    
    #[serde(rename = "OrgNo", skip_serializing_if = "Option::is_none")]
    pub org_no: Option<String>,
    
    #[serde(rename = "OriginalDueDate", skip_serializing_if = "Option::is_none")]
    pub original_due_date: Option<DateTime>,
    
    #[serde(rename = "OriginalInvoiceDate", skip_serializing_if = "Option::is_none")]
    pub original_invoice_date: Option<DateTime>,
    
    #[serde(rename = "OurReference", skip_serializing_if = "Option::is_none")]
    pub our_reference: Option<String>,
    
    #[serde(rename = "PaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "Phone", skip_serializing_if = "Option::is_none")]
    pub phone: Option<String>,
    
    #[serde(rename = "ReasonDescription", skip_serializing_if = "Option::is_none")]
    pub reason_description: Option<String>,
    
    #[serde(rename = "ReasonForHigherInterest", skip_serializing_if = "Option::is_none")]
    pub reason_for_higher_interest: Option<String>,
    
    #[serde(rename = "SourcePublicId", skip_serializing_if = "Option::is_none")]
    pub source_public_id: Option<String>,
    
    #[serde(rename = "StartDebtCollectionActionLevel", skip_serializing_if = "Option::is_none")]
    pub start_debt_collection_action_level: Option<DebtCollectionActionLevelTypeView>,
    
    #[serde(rename = "YourReference", skip_serializing_if = "Option::is_none")]
    pub your_reference: Option<String>,
    
    #[serde(rename = "ZipCode", skip_serializing_if = "Option::is_none")]
    pub zip_code: Option<String>,
    
}