
use crate::models::DateTime; 
use crate::models::DebtCollectionActionStageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct DebtCollectionActionStateView {
    
    #[serde(rename = "AttestedDate", skip_serializing_if = "Option::is_none")]
    pub attested_date: Option<DateTime>,
    
    #[serde(rename = "ClosedDate", skip_serializing_if = "Option::is_none")]
    pub closed_date: Option<DateTime>,
    
    #[serde(rename = "DebtCollectionInvoiceSentDate", skip_serializing_if = "Option::is_none")]
    pub debt_collection_invoice_sent_date: Option<DateTime>,
    
    #[serde(rename = "DisputedDate", skip_serializing_if = "Option::is_none")]
    pub disputed_date: Option<DateTime>,
    
    #[serde(rename = "HasPreviouslyBeenSentToInstallmentPlan", skip_serializing_if = "Option::is_none")]
    pub has_previously_been_sent_to_installment_plan: Option<bool>,
    
    #[serde(rename = "IsPaused", skip_serializing_if = "Option::is_none")]
    pub is_paused: Option<bool>,
    
    #[serde(rename = "LatePaymentInvoiceSentDate", skip_serializing_if = "Option::is_none")]
    pub late_payment_invoice_sent_date: Option<DateTime>,
    
    #[serde(rename = "NextEvent", skip_serializing_if = "Option::is_none")]
    pub next_event: Option<String>,
    
    #[serde(rename = "NextEventDate", skip_serializing_if = "Option::is_none")]
    pub next_event_date: Option<DateTime>,
    
    #[serde(rename = "NumberOfSentInvoiceReminders", skip_serializing_if = "Option::is_none")]
    pub number_of_sent_invoice_reminders: Option<i64>,
    
    #[serde(rename = "SentToBailiffDate", skip_serializing_if = "Option::is_none")]
    pub sent_to_bailiff_date: Option<DateTime>,
    
    #[serde(rename = "SentToBailiffEnforcementDate", skip_serializing_if = "Option::is_none")]
    pub sent_to_bailiff_enforcement_date: Option<DateTime>,
    
    #[serde(rename = "Stage", skip_serializing_if = "Option::is_none")]
    pub stage: Option<DebtCollectionActionStageTypeView>,
    
}