
use crate::models::CreditorBankInfoView; 
use crate::models::CreditorClaimsContactView; 
use crate::models::CreditorContactView; 
use crate::models::CreditorInvoiceAddressView; 
use crate::models::CreditorSignatoryContactView; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CreditorView {
    
    #[serde(rename = "Address", skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    
    #[serde(rename = "Address2", skip_serializing_if = "Option::is_none")]
    pub address2: Option<String>,
    
    #[serde(rename = "ApprovedCompanyTax", skip_serializing_if = "Option::is_none")]
    pub approved_company_tax: Option<bool>,
    
    #[serde(rename = "Attention", skip_serializing_if = "Option::is_none")]
    pub attention: Option<String>,
    
    #[serde(rename = "CareOf", skip_serializing_if = "Option::is_none")]
    pub care_of: Option<String>,
    
    #[serde(rename = "City", skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
    
    #[serde(rename = "CountryCode", skip_serializing_if = "Option::is_none")]
    pub country_code: Option<String>,
    
    #[serde(rename = "CreditorBankInfo", skip_serializing_if = "Option::is_none")]
    pub creditor_bank_info: Option<CreditorBankInfoView>,
    
    #[serde(rename = "CreditorClaimsContact", skip_serializing_if = "Option::is_none")]
    pub creditor_claims_contact: Option<CreditorClaimsContactView>,
    
    #[serde(rename = "CreditorContact", skip_serializing_if = "Option::is_none")]
    pub creditor_contact: Option<CreditorContactView>,
    
    #[serde(rename = "CreditorInvoiceAddress", skip_serializing_if = "Option::is_none")]
    pub creditor_invoice_address: Option<CreditorInvoiceAddressView>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "CreditorSignatoryContact", skip_serializing_if = "Option::is_none")]
    pub creditor_signatory_contact: Option<CreditorSignatoryContactView>,
    
    #[serde(rename = "GLN", skip_serializing_if = "Option::is_none")]
    pub gln: Option<String>,
    
    #[serde(rename = "IsEnabled", skip_serializing_if = "Option::is_none")]
    pub is_enabled: Option<bool>,
    
    #[serde(rename = "LogoURL", skip_serializing_if = "Option::is_none")]
    pub logo_url: Option<String>,
    
    #[serde(rename = "Name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    
    #[serde(rename = "NextInvoiceNumber", skip_serializing_if = "Option::is_none")]
    pub next_invoice_number: Option<String>,
    
    #[serde(rename = "OrgNo", skip_serializing_if = "Option::is_none")]
    pub org_no: Option<String>,
    
    #[serde(rename = "Phone", skip_serializing_if = "Option::is_none")]
    pub phone: Option<String>,
    
    #[serde(rename = "Residence", skip_serializing_if = "Option::is_none")]
    pub residence: Option<String>,
    
    #[serde(rename = "UseCentRounding", skip_serializing_if = "Option::is_none")]
    pub use_cent_rounding: Option<bool>,
    
    #[serde(rename = "UsesClientFundForInvoicing", skip_serializing_if = "Option::is_none")]
    pub uses_client_fund_for_invoicing: Option<bool>,
    
    #[serde(rename = "VatNumber", skip_serializing_if = "Option::is_none")]
    pub vat_number: Option<String>,
    
    #[serde(rename = "ZipCode", skip_serializing_if = "Option::is_none")]
    pub zip_code: Option<String>,
    
}