
use crate::models::CreditorKycFormBeneficialOwnerView; 
use crate::models::CreditorKycFormBusinessCategoryView; 
use crate::models::CreditorKycFormCompanyView; 
use crate::models::CreditorKycFormContactView; 
use crate::models::CreditorKycFormOwnerView; 
use crate::models::CreditorKycFormUsPersonView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CreditorKycFormView {
    
    #[serde(rename = "BeneficialOwners", skip_serializing_if = "Vec::is_empty", default)]
    pub beneficial_owners: Vec<CreditorKycFormBeneficialOwnerView>,
    
    #[serde(rename = "BusinessCategory", skip_serializing_if = "Option::is_none")]
    pub business_category: Option<CreditorKycFormBusinessCategoryView>,
    
    #[serde(rename = "Company", skip_serializing_if = "Option::is_none")]
    pub company: Option<CreditorKycFormCompanyView>,
    
    #[serde(rename = "Contact", skip_serializing_if = "Option::is_none")]
    pub contact: Option<CreditorKycFormContactView>,
    
    #[serde(rename = "HasAnyoneBusinessRelationWithOtherPEP", skip_serializing_if = "Option::is_none")]
    pub has_anyone_business_relation_with_other_pep: Option<bool>,
    
    #[serde(rename = "HasNoBeneficialOwners", skip_serializing_if = "Option::is_none")]
    pub has_no_beneficial_owners: Option<bool>,
    
    #[serde(rename = "HasNoOwnersWithMoreThan25Percent", skip_serializing_if = "Option::is_none")]
    pub has_no_owners_with_more_than25_percent: Option<bool>,
    
    #[serde(rename = "IsActiveNonFinancialInstitute", skip_serializing_if = "Option::is_none")]
    pub is_active_non_financial_institute: Option<bool>,
    
    #[serde(rename = "IsAnyOwnerUsPersons", skip_serializing_if = "Option::is_none")]
    pub is_any_owner_us_persons: Option<bool>,
    
    #[serde(rename = "IsAnyonePEP", skip_serializing_if = "Option::is_none")]
    pub is_anyone_pep: Option<bool>,
    
    #[serde(rename = "IsFinancialInstitute", skip_serializing_if = "Option::is_none")]
    pub is_financial_institute: Option<bool>,
    
    #[serde(rename = "IsManagingCash", skip_serializing_if = "Option::is_none")]
    pub is_managing_cash: Option<bool>,
    
    #[serde(rename = "IsManagingCurrenyExchanges", skip_serializing_if = "Option::is_none")]
    pub is_managing_curreny_exchanges: Option<bool>,
    
    #[serde(rename = "IsTaxableInUS", skip_serializing_if = "Option::is_none")]
    pub is_taxable_in_us: Option<bool>,
    
    #[serde(rename = "ManagingCashPurpose", skip_serializing_if = "Option::is_none")]
    pub managing_cash_purpose: Option<String>,
    
    #[serde(rename = "ManagingCashYearlyRevenue", skip_serializing_if = "Option::is_none")]
    pub managing_cash_yearly_revenue: Option<String>,
    
    #[serde(rename = "ManagingCurrenyExchangesPurpose", skip_serializing_if = "Option::is_none")]
    pub managing_curreny_exchanges_purpose: Option<String>,
    
    #[serde(rename = "OwnersWithMoreThan25Percent", skip_serializing_if = "Vec::is_empty", default)]
    pub owners_with_more_than25_percent: Vec<CreditorKycFormOwnerView>,
    
    #[serde(rename = "UsPersons", skip_serializing_if = "Vec::is_empty", default)]
    pub us_persons: Vec<CreditorKycFormUsPersonView>,
    
}