
use crate::models::LanguageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CreditCardPaymentIntentView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "FailureUrl", skip_serializing_if = "Option::is_none")]
    pub failure_url: Option<String>,
    
    #[serde(rename = "Language", skip_serializing_if = "Option::is_none")]
    pub language: Option<LanguageTypeView>,
    
    #[serde(rename = "SuccessUrl", skip_serializing_if = "Option::is_none")]
    pub success_url: Option<String>,
    
}