use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum BankIdHintCodeTypeView {
    
    cancelled,
    certificateErr,
    expiredTransaction,
    noClient,
    outstandingTransaction,
    startFailed,
    started,
    unknown,
    userCancel,
    userSign,

}


impl fmt::Display for BankIdHintCodeTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}