
use crate::models::BankIdHintCodeTypeView; 
use crate::models::BankIdStatusTypeView; 
use crate::models::DateTime; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct BankIdAuthenticationStatusView {
    
    #[serde(rename = "AutoStartToken", skip_serializing_if = "Option::is_none")]
    pub auto_start_token: Option<String>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "GivenName", skip_serializing_if = "Option::is_none")]
    pub given_name: Option<String>,
    
    #[serde(rename = "HintCode", skip_serializing_if = "Option::is_none")]
    pub hint_code: Option<BankIdHintCodeTypeView>,
    
    #[serde(rename = "IpAddress", skip_serializing_if = "Option::is_none")]
    pub ip_address: Option<String>,
    
    #[serde(rename = "Name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    
    #[serde(rename = "NotAfter", skip_serializing_if = "Option::is_none")]
    pub not_after: Option<DateTime>,
    
    #[serde(rename = "NotBefore", skip_serializing_if = "Option::is_none")]
    pub not_before: Option<DateTime>,
    
    #[serde(rename = "OcspResponse", skip_serializing_if = "Option::is_none")]
    pub ocsp_response: Option<String>,
    
    #[serde(rename = "ReferenceToken", skip_serializing_if = "Option::is_none")]
    pub reference_token: Option<String>,
    
    #[serde(rename = "SSN", skip_serializing_if = "Option::is_none")]
    pub ssn: Option<String>,
    
    #[serde(rename = "Signature", skip_serializing_if = "Option::is_none")]
    pub signature: Option<String>,
    
    #[serde(rename = "Status", skip_serializing_if = "Option::is_none")]
    pub status: Option<BankIdStatusTypeView>,
    
    #[serde(rename = "Surname", skip_serializing_if = "Option::is_none")]
    pub surname: Option<String>,
    
}