use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum AccountingRecordTypeView {
    
    Accrual,
    AdminsitrationCost,
    CentRounding,
    ClientFundDebt,
    CurrencyDifference,
    FinanceCostNoRecourse,
    FinanceCostWithRecourse,
    FreightCost,
    Interest,
    InvoiceSalesDebtAdded,
    InvoiceSalesDebtRemoved,
    NonPerformingLoanPurchase,
    OverPaymentDeleted,
    OverPaymentToBankAccount,
    PaymentToBankAccount,
    ProductSales,
    ProductSalesEU,
    ProductSalesEUVAT,
    ProductSalesNonEU,
    ProductSalesWithReverseVAT,
    PurchasedNonPerformingLoanPayment,
    ReminderCostPayment,
    RestingVAT,
    RotRutDiscount,
    SelfInvoiceCreditation,
    SelfInvoiceDebt,
    SelfInvoiceDebtVAT,
    SelfInvoicePaymentFromBankAccount,
    SupplierPaymentFromBankAccount,
    SupplierPurchaseDebt,
    SupplierPurchaseEU,
    SupplierPurchaseEUVAT,
    SupplierPurchaseNonEU,
    UnmatchedPaymentDeleted,
    UnmatchedPaymentToBankAccount,
    WriteOff,

}


impl fmt::Display for AccountingRecordTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}