
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct AccountingPaymentMeanView {
    
    #[serde(rename = "BookkeepingAccount", skip_serializing_if = "Option::is_none")]
    pub bookkeeping_account: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "Description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    
    #[serde(rename = "PaymentCode", skip_serializing_if = "Option::is_none")]
    pub payment_code: Option<String>,
    
}