
use crate::models::AccountingExportDateSelectionTypeView; 
use crate::models::AccountingExportFormatTypeView; 
use crate::models::DateTime; 
use crate::models::FileView; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct AccountingExportView {
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CreatedBy", skip_serializing_if = "Option::is_none")]
    pub created_by: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DateSelectionType", skip_serializing_if = "Option::is_none")]
    pub date_selection_type: Option<AccountingExportDateSelectionTypeView>,
    
    #[serde(rename = "End", skip_serializing_if = "Option::is_none")]
    pub end: Option<DateTime>,
    
    #[serde(rename = "File", skip_serializing_if = "Option::is_none")]
    pub file: Option<FileView>,
    
    #[serde(rename = "Format", skip_serializing_if = "Option::is_none")]
    pub format: Option<AccountingExportFormatTypeView>,
    
    #[serde(rename = "Start", skip_serializing_if = "Option::is_none")]
    pub start: Option<DateTime>,
    
}