use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     Base64,
     CommentActionView,
     CommonActionEventsView,
     CreatedView,
     CreditCardPaymentIntentView,
     CreditCardPaymentView,
     CreditCardPaymentsView,
     DateTime,
     DeliveryMethodTypeView,
     Guid,
     InterestTypeView,
     InvoiceActionEntryView,
     InvoiceActionRotRutProcessedsView,
     InvoiceActionSubsView,
     InvoiceActionView,
     RegisterPaymentView,
     ReminderInvoiceActionSubsView,
     ReminderInvoiceActionView,
     SendReminderInvoiceView,
     UpdateAddressActionView,
     VerificationInvoiceActionEntryView,
    
};


impl Client {
    
    

/// Attesting an invoice means that it will be book kept and locked for editing. Invoice is automatically sent if any distribution is set.
/// - **id**: Invoice action public id
pub async fn invoice_attest_an_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("attest"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// The autogiro withdrawal can be cancelled using this endpoint. Note that this can't be done up to the day before the autogiro withdrawal date (day before due date)
/// - **id**: Invoice public id
pub async fn invoice_cancel_autogiro_withdrawal(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("autogiro"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// The credit card payment can be cancelled if payment has not been completed yet.
/// - **id**: Credit card payment public Id
pub async fn invoice_cancel_credit_card_payment(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("creditcardpayment"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Removed the invoice dispute flag which reenables all automatic events on the invoice again
/// - **id**: Invoice public id
pub async fn invoice_cancel_invoice_dispute(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("canceldispute"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Canceling the reminder invoice will also remove any added reminder fees to the invoice
/// - **id**: Invoice public id
pub async fn invoice_cancel_reminder_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("cancelreminder"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// If invoice has not been accepted by purchaser the invoice sales can be cancelled and reverted.
/// - **id**: Invoice public id
/// - **comment**: Comment for cancelling the sales
pub async fn invoice_cancel_the_invoice_sales(&self,id: String,
                         comment: Option<String>,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("sellinvoice"))
        .url(Param::value(id))
        .query("comment", Param::opt(comment))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Writes a comment to the self invoice events log.
pub async fn invoice_comment_an_invoice(&self,body: CommentActionView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("comment"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Creates ROT-XML ready to be sent to Skatteverket. This endpoint returns a PDF data stream in the content
/// - **actionpublicid**: The ActionPublicId to get XML for
pub async fn invoice_create_rot_xml_file(&self,actionpublicid: String,
                         
) -> Result<Base64> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("rotxml"))
        .query("actionpublicid", Param::value(actionpublicid))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Creates RUT-XML ready to be sent to Skatteverket. This endpoint returns a PDF data stream in the content
/// - **actionpublicid**: The ActionPublicId to get XML for
pub async fn invoice_create_rut_xml_file(&self,actionpublicid: String,
                         
) -> Result<Base64> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("rutxml"))
        .query("actionpublicid", Param::value(actionpublicid))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// A verification invoice is a pure bookkeeping event. You create the verification to write to the bookkeeping and have a 'receipt' on the invoice for tracking. It is automatically closed after creation.
pub async fn invoice_create_a_verification_invoice(&self,body: VerificationInvoiceActionEntryView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("verificationinvoice"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// All created invoices are saved and not attested. To make it permanent and bookkeep it, the invoice action must be attested.
pub async fn invoice_create_an_invoice(&self,body: InvoiceActionEntryView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("action"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Creates an autogiro withdrawal on the latest of todays date or the invoice due date
/// - **id**: Invoice public id
pub async fn invoice_create_autogiro_withdrawal(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("autogiro"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Make an credit card payment intent with the amount on the invoice.
pub async fn invoice_create_credit_card_payment_intent(&self,body: CreditCardPaymentIntentView,
                         
) -> Result<CreditCardPaymentView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("creditcardpayment"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// According to law an invoice sender has the right to invoice the lost interest on a due invoice. By calling this endpoint an interest invoice will be sent with only the interest generated between the from and to date. Note that Billecta doesn't take consideration on the from and to date overlap with another reminder invoice with the same from and to date.
/// - **id**: Invoice public id from which to create from
/// - **from**: Interest from date
/// - **to**: Interest to date
/// - **interesttype**: Interest type
/// - **interest**: Interest in percent
pub async fn invoice_create_interest_invoice(&self,id: String,
                         from: DateTime,
                         to: DateTime,
                         interesttype: InterestTypeView,
                         interest: f64,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("interestinvoice"))
        .url(Param::value(id))
        .query("from", Param::value(from))
        .query("to", Param::value(to))
        .query("interesttype", Param::value(interesttype))
        .query("interest", Param::value(interest))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// A debit and credit invoice can be connected and balance each other out by this endpoint. If both have the same amount (the other one negative), then both will be closed. If one invoice has more amount than the other one, one of them will be closed and the other will have a current amount equal to the difference.
/// - **id**: Invoice public id
/// - **creditinvoiceactionpublicid**: Invoice public id of the invoice to credit
/// - **paymentmeancode**: Payment mean code
pub async fn invoice_credit_an_invoice_with_existing_credit_invoice(&self,id: String,
                         creditinvoiceactionpublicid: String,
                         paymentmeancode: Option<String>,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("creditaction"))
        .url(Param::value(id))
        .query("creditinvoiceactionpublicid", Param::value(creditinvoiceactionpublicid))
        .query("paymentmeancode", Param::opt(paymentmeancode))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Delete the overridden debtor address and uses the address from the debtor/customer card
/// - **id**: Invoice action public id
pub async fn invoice_delete_address_override_for_an_invoice(&self,id: String,
                         body: UpdateAddressActionView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("address"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Only non-attested invoices can be deleted. Once attested it is locked and deletion is not allowed any more.
/// - **id**: Invoice public id
pub async fn invoice_delete_an_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("action"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// According to law a debtor/customer has the right to dispute an invoice (regardless reason). If such a knowledge is known to the customer no more automatic events are allowed to perform on the invoice (like sending it to debt collection)
/// - **id**: Invoice public id
pub async fn invoice_dispute_an_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("dispute"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Retrieves all invoices that have a closed/full payment date between the specified from and to dates.
/// - **id**: Creditor public id
/// - **from**: From date
/// - **to**: To date
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn invoice_get_all_closed_invoices(&self,id: Guid,
                         from: DateTime,
                         to: DateTime,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<InvoiceActionSubsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("closed"))
        .url(Param::value(id))
        .query("from", Param::value(from))
        .query("to", Param::value(to))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Gets all credit card payment intents for a given invoice
/// - **id**: Action public id
pub async fn invoice_get_all_credit_card_payment_intents(&self,id: String,
                         
) -> Result<CreditCardPaymentsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("creditcardpayments"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// 
/// - **id**: Creditor public id
/// - **from**: From date
/// - **to**: To date
pub async fn invoice_get_all_events_for_all_invoices(&self,id: Guid,
                         from: String,
                         to: String,
                         
) -> Result<CommonActionEventsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("events"))
        .url(Param::value(id))
        .query("from", Param::value(from))
        .query("to", Param::value(to))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Retrieves all drafts/attested and unpaid invoices.
/// - **id**: Creditor public id
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn invoice_get_all_open_invoices(&self,id: Guid,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<InvoiceActionSubsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("open"))
        .url(Param::value(id))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get all open reminder invoices. Use this endpoint to see which invoices have an active reminder
/// - **id**: Creditor public id
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn invoice_get_all_open_reminder_invoices(&self,id: Guid,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<ReminderInvoiceActionSubsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("openreminders"))
        .url(Param::value(id))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Returns an invoice based on the ActionPublicId. All invoices have a unique ActionPublicId that is generated on creation.
/// - **id**: Invoice public id
pub async fn invoice_get_an_invoice(&self,id: String,
                         
) -> Result<InvoiceActionView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("action"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Invoices where XML has been generated can be marked as processed. Use this endpoint to retrieve a list of invoices that have been created between from and to and that are marked as processed for ROT
/// - **id**: The ActionPublicId to get XML for
/// - **createdfrom**: Creditor public id
/// - **createdto**: Invoice creation from date
pub async fn invoice_get_invoices_that_are_processed_for_rot_between_two_dates(&self,id: String,
                         createdfrom: Guid,
                         createdto: DateTime,
                         
) -> Result<InvoiceActionRotRutProcessedsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("rotprocessed"))
        .url(Param::value(id))
        .query("createdfrom", Param::value(createdfrom))
        .query("createdto", Param::value(createdto))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Invoices where XML has been generated can be marked as processed. Use this endpoint to retrieve a list of invoices that have been created between from and to and that are marked as processed for RUT
/// - **id**: The ActionPublicId to get XML for
/// - **createdfrom**: Creditor public id
/// - **createdto**: Invoice creation from date
pub async fn invoice_get_invoices_that_are_processed_for_rut_between_two_dates(&self,id: String,
                         createdfrom: Guid,
                         createdto: DateTime,
                         
) -> Result<InvoiceActionRotRutProcessedsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("rutprocessed"))
        .url(Param::value(id))
        .query("createdfrom", Param::value(createdfrom))
        .query("createdto", Param::value(createdto))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Invoice reminders can be sent using the Invoice/SendReminderInvoice endpoint. Call this endpoint to retrieve metadata about the reminder.
/// - **id**: Invoice public id
pub async fn invoice_get_reminder_invoice(&self,id: String,
                         
) -> Result<ReminderInvoiceActionView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("reminder"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Invoice events gets archived after one year. This reloads archived events to enable the events to be retrieved again. Observe that these events will be archived again after one day.
/// - **id**: Invoice action public id
pub async fn invoice_load_archived_events(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("loadarchivedevents"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Invoices where XML has been generated can be marked as processed and filtered/hidden when exporting XML for other invoices
/// - **actionpublicid**: The ActionPublicId to get XML for
pub async fn invoice_mark_invoices_are_processed_for_rot(&self,actionpublicid: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("rotprocessed"))
        .query("actionpublicid", Param::value(actionpublicid))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Invoices where XML has been generated can be marked as processed and filtered/hidden when exporting XML for other invoices
/// - **actionpublicid**: The ActionPublicId to get XML for
pub async fn invoice_mark_invoices_are_processed_for_rut(&self,actionpublicid: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("rutprocessed"))
        .query("actionpublicid", Param::value(actionpublicid))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// If you have two or more invoices to the same customer you can merge all invoices to one single one. The old ones will be deleted and a new one will be created with a new ActionPublicId.
/// - **actionpublicid**: Id of the invoices
/// - **invoicedate**: Invoice date of the merged invoice
/// - **duedate**: Due date of the merged invoice
/// - **deliverydate**: Delivery date of the merged invoice
pub async fn invoice_merge_invoices(&self,actionpublicid: String,
                         invoicedate: Option<DateTime>,
                         duedate: Option<DateTime>,
                         deliverydate: Option<DateTime>,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("merge"))
        .query("actionpublicid", Param::value(actionpublicid))
        .query("invoicedate", Param::opt(invoicedate))
        .query("duedate", Param::opt(duedate))
        .query("deliverydate", Param::opt(deliverydate))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Pauses the invoice from any more automatic events.
/// - **id**: Invoice public id
pub async fn invoice_pause_an_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("pause"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Postpones the next automatic event of an invoice. Note that it is only possible to postpone forward and not backwards
/// - **id**: Invoice public id
/// - **days**: Number of days to postpone next event
pub async fn invoice_postpone_next_event_by_days(&self,id: String,
                         days: i64,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("postpone"))
        .url(Param::value(id))
        .query("days", Param::value(days))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Postpones the next automatic event of an invoice. Note that it is only possible to postpone forward and not backwards
/// - **id**: Invoice public id
/// - **date**: Date to postpone next event to
pub async fn invoice_postpone_next_event_until(&self,id: String,
                         date: DateTime,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("postpone"))
        .url(Param::value(id))
        .query("date", Param::value(date))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Preview an invoice to view how it will be generated. This endpoint previews data already stored in API/database. This endpoint returns a PDF data stream in the content
/// - **id**: Invoice public id
pub async fn invoice_preview_an_invoice_by_id(&self,id: String,
                         
) -> Result<Base64> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("preview"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Preview an invoice to view how it will be generated. This endpoint previews data sent in the request and ignores data stored in the API/database. This endpoint returns a PDF data stream in the content
pub async fn invoice_preview_an_invoice(&self,body: InvoiceActionEntryView,
                         
) -> Result<Base64> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("preview"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// The credit card payment can be refunded if payment has been completed.
/// - **id**: Credit card payment public Id
pub async fn invoice_refund_credit_card_payment(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("refundcreditcardpayment"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// The swish payment can be refunded if payment has been completed.
/// - **id**: Swish payment token/public id
pub async fn invoice_refund_swish_payment(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("refundswishpayment"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Register an already received payment on the invoice that was not received through Billecta.
pub async fn invoice_register_payment_on_an_invoice(&self,body: RegisterPaymentView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("registerpayment"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Resumes the self invoice to automatically process events.
/// - **id**: Invoice public id
pub async fn invoice_resume_a_paused_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("resume"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Sells the invoice to a purchaser according to specified sales contract. If no contract is specified and only one exists that invoice sale contract will be used.
/// - **id**: Invoice public id
/// - **salescontractpublicid**: Invoice sales contract public id
pub async fn invoice_sell_the_invoice(&self,id: String,
                         salescontractpublicid: Option<Guid>,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("sellinvoice"))
        .url(Param::value(id))
        .query("salescontractpublicid", Param::opt(salescontractpublicid))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Sends the invoice with the preferred delivery method. Note that omitting optional parameters will use pre-stored values on the invoice.
/// - **id**: Invoice public id
/// - **method**: The method to send the invoice
pub async fn invoice_send_the_invoice(&self,id: String,
                         method: Option<DeliveryMethodTypeView>,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("sendinvoice"))
        .url(Param::value(id))
        .query("method", Param::opt(method))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Creates and sends a reminder invoice for the invoice. Reminder fees and PDF:s will be added to the invoice.
/// - **id**: Invoice public id
/// - **method**: The method to send the invoice
pub async fn invoice_send_the_reminder_invoice(&self,id: String,
                         method: Option<DeliveryMethodTypeView>,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("sendreminderinvoice"))
        .url(Param::value(id))
        .query("method", Param::opt(method))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Uses a already reminder PDF generated by you and sends it. Reminder fees and PDF:s will be added to the invoice.
pub async fn invoice_send_the_reminder_invoice_with_pregenerated_pdf(&self,body: SendReminderInvoiceView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("sendreminderinvoice"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// 
/// - **actionpublicid**: The ActionPublicId to get XML for
pub async fn invoice_unmark_invoices_are_processed_for_rot(&self,actionpublicid: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("rotprocessed"))
        .query("actionpublicid", Param::value(actionpublicid))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// 
/// - **actionpublicid**: The ActionPublicId to get XML for
pub async fn invoice_unmark_invoices_are_processed_for_rut(&self,actionpublicid: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("rutprocessed"))
        .query("actionpublicid", Param::value(actionpublicid))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Overrides the customer/debtor address and sets a temporary address for this invoice only
pub async fn invoice_update_address_on_an_invoice(&self,body: UpdateAddressActionView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("address"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Note that only non-attested invoices can be updated. Once attested it is locked and update is not possible any more.
/// - **id**: Invoice public id
pub async fn invoice_update_an_invoice(&self,id: String,
                         body: InvoiceActionEntryView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("invoice"))
        .url(Param::value("action"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
}