use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     CreatedView,
     MailDeliveryView,
     SmsDeliveryView,
    
};


impl Client {
    
    

/// Sends the posted PDF file (and appendixes [optional]) with mail delivery. One file (and appendixes [optional]) is one post delivery/envelope. The PDF's needs to be in A4 format, main file needs to have sender and receiver information according to our standard on the first page and total file after merge with appendixes [optional] can not excced 10 MB. 
pub async fn delivery_send_a_mail(&self,body: MailDeliveryView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("delivery"))
        .url(Param::value("mail"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Sends a SMS to the specified phone number. Sender will be your company name. Line breaks are added by typing \n\r in the message.
pub async fn delivery_send_a_sms_text(&self,body: SmsDeliveryView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("delivery"))
        .url(Param::value("sms"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
}