use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum SupplierInvoiceActionStageTypeView {
    
    Attested,
    Cancelled,
    Completed,
    Created,
    Manual,
    None,
    PaymentCancelled,
    PaymentSent,

}


impl fmt::Display for SupplierInvoiceActionStageTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}