
use crate::models::AmountView; 
use crate::models::Base64; 
use crate::models::DeliveryMethodTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct SendReminderInvoiceView {
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "InvoiceActionPublicId", skip_serializing_if = "Option::is_none")]
    pub invoice_action_public_id: Option<String>,
    
    #[serde(rename = "PaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "ReminderFee", skip_serializing_if = "Option::is_none")]
    pub reminder_fee: Option<AmountView>,
    
    #[serde(rename = "Stream", skip_serializing_if = "Option::is_none")]
    pub stream: Option<Base64>,
    
    #[serde(rename = "Url", skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    
}