
use crate::models::AmountView; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::FileView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct SendReconciliationInvoiceReminderView {
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "ReconciliationInvoiceActionPublicId", skip_serializing_if = "Option::is_none")]
    pub reconciliation_invoice_action_public_id: Option<String>,
    
    #[serde(rename = "ReminderFee", skip_serializing_if = "Option::is_none")]
    pub reminder_fee: Option<AmountView>,
    
    #[serde(rename = "ReminderFile", skip_serializing_if = "Option::is_none")]
    pub reminder_file: Option<FileView>,
    
    #[serde(rename = "SendAsPriorityMail", skip_serializing_if = "Option::is_none")]
    pub send_as_priority_mail: Option<bool>,
    
    #[serde(rename = "SendWithColor", skip_serializing_if = "Option::is_none")]
    pub send_with_color: Option<bool>,
    
}