use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum RotRutTypeView {
    
    BabySitting,
    Cleaning,
    Construction,
    Electricity,
    Gardening,
    GlassMetalWork,
    GroundDrainageWork,
    Hvac,
    ITServices,
    Masonry,
    Moving,
    PaintingWallpapering,
    PersonalCare,
    SnowPlowing,
    TextileClothing,
    WhiteGoods,

}


impl fmt::Display for RotRutTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}