
use crate::models::RotRutCustomerView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct RotRutDetailsView {
    
    #[serde(rename = "Customers", skip_serializing_if = "Vec::is_empty", default)]
    pub customers: Vec<RotRutCustomerView>,
    
    #[serde(rename = "PropertyDesignation", skip_serializing_if = "Option::is_none")]
    pub property_designation: Option<String>,
    
    #[serde(rename = "ResidenceAssociationOrgNo", skip_serializing_if = "Option::is_none")]
    pub residence_association_org_no: Option<String>,
    
}