
use crate::models::AmountView; 
use crate::models::DateTime; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct RegisterReconciliationPaymentView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "Amount", skip_serializing_if = "Option::is_none")]
    pub amount: Option<AmountView>,
    
    #[serde(rename = "AmountIsCredit", skip_serializing_if = "Option::is_none")]
    pub amount_is_credit: Option<bool>,
    
    #[serde(rename = "Comment", skip_serializing_if = "Option::is_none")]
    pub comment: Option<String>,
    
    #[serde(rename = "Date", skip_serializing_if = "Option::is_none")]
    pub date: Option<DateTime>,
    
    #[serde(rename = "PaymentMeanCode", skip_serializing_if = "Option::is_none")]
    pub payment_mean_code: Option<String>,
    
    #[serde(rename = "WriteOff", skip_serializing_if = "Option::is_none")]
    pub write_off: Option<AmountView>,
    
    #[serde(rename = "WriteOffVat", skip_serializing_if = "Option::is_none")]
    pub write_off_vat: Option<f64>,
    
}