
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::FileView; 
use crate::models::Guid; 
use crate::models::LanguageTypeView; 
use crate::models::ReconciliationDebtorView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct ReconciliationInvoiceActionEntryView {
    
    #[serde(rename = "AutogiroWithdrawalDate", skip_serializing_if = "Option::is_none")]
    pub autogiro_withdrawal_date: Option<DateTime>,
    
    #[serde(rename = "CommunicationLanguage", skip_serializing_if = "Option::is_none")]
    pub communication_language: Option<LanguageTypeView>,
    
    #[serde(rename = "CreditCardWithdrawalDate", skip_serializing_if = "Option::is_none")]
    pub credit_card_withdrawal_date: Option<DateTime>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "CurrentAmount", skip_serializing_if = "Option::is_none")]
    pub current_amount: Option<AmountView>,
    
    #[serde(rename = "CurrentReminderFees", skip_serializing_if = "Option::is_none")]
    pub current_reminder_fees: Option<AmountView>,
    
    #[serde(rename = "Debtor", skip_serializing_if = "Option::is_none")]
    pub debtor: Option<ReconciliationDebtorView>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "ExternalReference", skip_serializing_if = "Option::is_none")]
    pub external_reference: Option<String>,
    
    #[serde(rename = "ExternalUrl", skip_serializing_if = "Option::is_none")]
    pub external_url: Option<String>,
    
    #[serde(rename = "InvoiceFile", skip_serializing_if = "Option::is_none")]
    pub invoice_file: Option<FileView>,
    
    #[serde(rename = "InvoiceNumber", skip_serializing_if = "Option::is_none")]
    pub invoice_number: Option<String>,
    
    #[serde(rename = "OCR", skip_serializing_if = "Option::is_none")]
    pub ocr: Option<String>,
    
    #[serde(rename = "SendAsPriorityMail", skip_serializing_if = "Option::is_none")]
    pub send_as_priority_mail: Option<bool>,
    
    #[serde(rename = "SendWithColor", skip_serializing_if = "Option::is_none")]
    pub send_with_color: Option<bool>,
    
}