
use crate::models::ReceivingAccountTypeView; 
use crate::models::ReferenceTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct PaymentOverrideView {
    
    #[serde(rename = "AccountNo", skip_serializing_if = "Option::is_none")]
    pub account_no: Option<String>,
    
    #[serde(rename = "BankGiro", skip_serializing_if = "Option::is_none")]
    pub bank_giro: Option<String>,
    
    #[serde(rename = "BankName", skip_serializing_if = "Option::is_none")]
    pub bank_name: Option<String>,
    
    #[serde(rename = "Bic", skip_serializing_if = "Option::is_none")]
    pub bic: Option<String>,
    
    #[serde(rename = "ClearingNo", skip_serializing_if = "Option::is_none")]
    pub clearing_no: Option<String>,
    
    #[serde(rename = "Iban", skip_serializing_if = "Option::is_none")]
    pub iban: Option<String>,
    
    #[serde(rename = "PaymentReceiver", skip_serializing_if = "Option::is_none")]
    pub payment_receiver: Option<String>,
    
    #[serde(rename = "PlusGiro", skip_serializing_if = "Option::is_none")]
    pub plus_giro: Option<String>,
    
    #[serde(rename = "ReceivingAccountType", skip_serializing_if = "Option::is_none")]
    pub receiving_account_type: Option<ReceivingAccountTypeView>,
    
    #[serde(rename = "Reference", skip_serializing_if = "Option::is_none")]
    pub reference: Option<String>,
    
    #[serde(rename = "ReferenceType", skip_serializing_if = "Option::is_none")]
    pub reference_type: Option<ReferenceTypeView>,
    
}