
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::DiscountTypeView; 
use crate::models::Guid; 
use crate::models::RecordTypeView; 
use crate::models::RotRutTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct InvoiceActionRecordView {
    
    #[serde(rename = "ArticleDescription", skip_serializing_if = "Option::is_none")]
    pub article_description: Option<String>,
    
    #[serde(rename = "ArticleNumber", skip_serializing_if = "Option::is_none")]
    pub article_number: Option<String>,
    
    #[serde(rename = "CostCenter", skip_serializing_if = "Option::is_none")]
    pub cost_center: Option<String>,
    
    #[serde(rename = "DiscountAmount", skip_serializing_if = "Option::is_none")]
    pub discount_amount: Option<AmountView>,
    
    #[serde(rename = "DiscountPercentage", skip_serializing_if = "Option::is_none")]
    pub discount_percentage: Option<f64>,
    
    #[serde(rename = "DiscountType", skip_serializing_if = "Option::is_none")]
    pub discount_type: Option<DiscountTypeView>,
    
    #[serde(rename = "Hidden", skip_serializing_if = "Option::is_none")]
    pub hidden: Option<bool>,
    
    #[serde(rename = "PeriodEnd", skip_serializing_if = "Option::is_none")]
    pub period_end: Option<DateTime>,
    
    #[serde(rename = "PeriodStart", skip_serializing_if = "Option::is_none")]
    pub period_start: Option<DateTime>,
    
    #[serde(rename = "ProductPublicId", skip_serializing_if = "Option::is_none")]
    pub product_public_id: Option<Guid>,
    
    #[serde(rename = "Project", skip_serializing_if = "Option::is_none")]
    pub project: Option<String>,
    
    #[serde(rename = "Quantity", skip_serializing_if = "Option::is_none")]
    pub quantity: Option<f64>,
    
    #[serde(rename = "RecordType", skip_serializing_if = "Option::is_none")]
    pub record_type: Option<RecordTypeView>,
    
    #[serde(rename = "RotRutActivated", skip_serializing_if = "Option::is_none")]
    pub rot_rut_activated: Option<bool>,
    
    #[serde(rename = "RotRutAmount", skip_serializing_if = "Option::is_none")]
    pub rot_rut_amount: Option<AmountView>,
    
    #[serde(rename = "RotRutHours", skip_serializing_if = "Option::is_none")]
    pub rot_rut_hours: Option<i64>,
    
    #[serde(rename = "RotRutMaterialCostAmount", skip_serializing_if = "Option::is_none")]
    pub rot_rut_material_cost_amount: Option<AmountView>,
    
    #[serde(rename = "RotRutType", skip_serializing_if = "Option::is_none")]
    pub rot_rut_type: Option<RotRutTypeView>,
    
    #[serde(rename = "SequenceNo", skip_serializing_if = "Option::is_none")]
    pub sequence_no: Option<i64>,
    
    #[serde(rename = "UnitPrice", skip_serializing_if = "Option::is_none")]
    pub unit_price: Option<AmountView>,
    
    #[serde(rename = "Units", skip_serializing_if = "Option::is_none")]
    pub units: Option<String>,
    
    #[serde(rename = "VAT", skip_serializing_if = "Option::is_none")]
    pub vat: Option<f64>,
    
    #[serde(rename = "VatIsIncluded", skip_serializing_if = "Option::is_none")]
    pub vat_is_included: Option<bool>,
    
}