
use crate::models::ActionTypeView; 
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::FileView; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct IncomingPaymentView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "ActionType", skip_serializing_if = "Option::is_none")]
    pub action_type: Option<ActionTypeView>,
    
    #[serde(rename = "Amount", skip_serializing_if = "Option::is_none")]
    pub amount: Option<AmountView>,
    
    #[serde(rename = "CreatedDate", skip_serializing_if = "Option::is_none")]
    pub created_date: Option<DateTime>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DebtorName", skip_serializing_if = "Option::is_none")]
    pub debtor_name: Option<String>,
    
    #[serde(rename = "DebtorPublicId", skip_serializing_if = "Option::is_none")]
    pub debtor_public_id: Option<Guid>,
    
    #[serde(rename = "ExternalReference", skip_serializing_if = "Option::is_none")]
    pub external_reference: Option<String>,
    
    #[serde(rename = "File", skip_serializing_if = "Option::is_none")]
    pub file: Option<FileView>,
    
    #[serde(rename = "InvoiceNumber", skip_serializing_if = "Option::is_none")]
    pub invoice_number: Option<String>,
    
    #[serde(rename = "IsReminderPayment", skip_serializing_if = "Option::is_none")]
    pub is_reminder_payment: Option<bool>,
    
    #[serde(rename = "OCR", skip_serializing_if = "Option::is_none")]
    pub ocr: Option<String>,
    
    #[serde(rename = "PaymentDate", skip_serializing_if = "Option::is_none")]
    pub payment_date: Option<DateTime>,
    
    #[serde(rename = "PaymentMeanCode", skip_serializing_if = "Option::is_none")]
    pub payment_mean_code: Option<String>,
    
    #[serde(rename = "PaymentReferenceId", skip_serializing_if = "Option::is_none")]
    pub payment_reference_id: Option<Guid>,
    
}