
use crate::models::DateTime; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct IncomingPaymentRequestView {
    
    #[serde(rename = "ActionPublicIdFilter", skip_serializing_if = "Vec::is_empty", default)]
    pub action_public_id_filter: Vec<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "From", skip_serializing_if = "Option::is_none")]
    pub from: Option<DateTime>,
    
    #[serde(rename = "PaymentMeanCodeFilter", skip_serializing_if = "Vec::is_empty", default)]
    pub payment_mean_code_filter: Vec<String>,
    
    #[serde(rename = "ProjectNumberFilter", skip_serializing_if = "Vec::is_empty", default)]
    pub project_number_filter: Vec<String>,
    
    #[serde(rename = "To", skip_serializing_if = "Option::is_none")]
    pub to: Option<DateTime>,
    
}