
use crate::models::DateTime; 
use crate::models::DebtorAutogiroView; 
use crate::models::DebtorCreditCardView; 
use crate::models::DebtorDefaultActionConfigView; 
use crate::models::DebtorSelfInvoiceInfoView; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct DebtorView {
    
    #[serde(rename = "Address", skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    
    #[serde(rename = "Address2", skip_serializing_if = "Option::is_none")]
    pub address2: Option<String>,
    
    #[serde(rename = "Attention", skip_serializing_if = "Option::is_none")]
    pub attention: Option<String>,
    
    #[serde(rename = "Autogiro", skip_serializing_if = "Option::is_none")]
    pub autogiro: Option<DebtorAutogiroView>,
    
    #[serde(rename = "CareOf", skip_serializing_if = "Option::is_none")]
    pub care_of: Option<String>,
    
    #[serde(rename = "CitizenshipCountryCode", skip_serializing_if = "Option::is_none")]
    pub citizenship_country_code: Option<String>,
    
    #[serde(rename = "City", skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
    
    #[serde(rename = "ContactEmail", skip_serializing_if = "Option::is_none")]
    pub contact_email: Option<String>,
    
    #[serde(rename = "ContactName", skip_serializing_if = "Option::is_none")]
    pub contact_name: Option<String>,
    
    #[serde(rename = "CountryCode", skip_serializing_if = "Option::is_none")]
    pub country_code: Option<String>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CreditCards", skip_serializing_if = "Vec::is_empty", default)]
    pub credit_cards: Vec<DebtorCreditCardView>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DebtorExternalId", skip_serializing_if = "Option::is_none")]
    pub debtor_external_id: Option<String>,
    
    #[serde(rename = "DebtorNo", skip_serializing_if = "Option::is_none")]
    pub debtor_no: Option<String>,
    
    #[serde(rename = "DebtorPublicId", skip_serializing_if = "Option::is_none")]
    pub debtor_public_id: Option<Guid>,
    
    #[serde(rename = "DebtorSelfInvoiceInfo", skip_serializing_if = "Option::is_none")]
    pub debtor_self_invoice_info: Option<DebtorSelfInvoiceInfoView>,
    
    #[serde(rename = "DebtorType", skip_serializing_if = "Option::is_none")]
    pub debtor_type: Option<String>,
    
    #[serde(rename = "DefaultActionConfig", skip_serializing_if = "Option::is_none")]
    pub default_action_config: Option<DebtorDefaultActionConfigView>,
    
    #[serde(rename = "EInvoiceBank", skip_serializing_if = "Option::is_none")]
    pub e_invoice_bank: Option<String>,
    
    #[serde(rename = "Email", skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    
    #[serde(rename = "GLN", skip_serializing_if = "Option::is_none")]
    pub gln: Option<String>,
    
    #[serde(rename = "Intermediator", skip_serializing_if = "Option::is_none")]
    pub intermediator: Option<String>,
    
    #[serde(rename = "IsActive", skip_serializing_if = "Option::is_none")]
    pub is_active: Option<bool>,
    
    #[serde(rename = "Name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    
    #[serde(rename = "Notes", skip_serializing_if = "Option::is_none")]
    pub notes: Option<String>,
    
    #[serde(rename = "OrgNo", skip_serializing_if = "Option::is_none")]
    pub org_no: Option<String>,
    
    #[serde(rename = "Phone", skip_serializing_if = "Option::is_none")]
    pub phone: Option<String>,
    
    #[serde(rename = "ProtectedIdentity", skip_serializing_if = "Option::is_none")]
    pub protected_identity: Option<bool>,
    
    #[serde(rename = "VatNumber", skip_serializing_if = "Option::is_none")]
    pub vat_number: Option<String>,
    
    #[serde(rename = "ZipCode", skip_serializing_if = "Option::is_none")]
    pub zip_code: Option<String>,
    
}