

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CurrencyView {
    
    #[serde(rename = "BankGiroSupportCurrencied", skip_serializing_if = "Vec::is_empty", default)]
    pub bank_giro_support_currencied: Box<Vec<CurrencyView>>,
    
    #[serde(rename = "CurrencyCode", skip_serializing_if = "Option::is_none")]
    pub currency_code: Option<String>,
    
    #[serde(rename = "Decimals", skip_serializing_if = "Option::is_none")]
    pub decimals: Option<i64>,
    
    #[serde(rename = "DefaultCurrency", skip_serializing_if = "Option::is_none")]
    pub default_currency: Option<Box<CurrencyView>>,
    
    #[serde(rename = "Description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    
    #[serde(rename = "Iso4217", skip_serializing_if = "Option::is_none")]
    pub iso4217: Option<String>,
    
    #[serde(rename = "OneUnit", skip_serializing_if = "Option::is_none")]
    pub one_unit: Option<i64>,
    
}