
use crate::models::ActionTypeView; 
use crate::models::AmountView; 
use crate::models::ContractInvoiceActionAttachmentView; 
use crate::models::ContractInvoiceActionEventView; 
use crate::models::ContractInvoiceActionRecordView; 
use crate::models::ContractInvoiceActionStateView; 
use crate::models::ContractInvoicePeriodRuleTypeView; 
use crate::models::DebtCollectionDetailsView; 
use crate::models::DeliveryAddressOverrideView; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::Guid; 
use crate::models::InterestTypeView; 
use crate::models::LanguageTypeView; 
use crate::models::PaymentOverrideView; 
use crate::models::RecurrenceDetailsView; 
use crate::models::ReminderInvoiceDetailsView; 
use crate::models::ReverseVATDetailsView; 
use crate::models::RotRutDetailsView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct ContractInvoiceActionView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "Amount", skip_serializing_if = "Option::is_none")]
    pub amount: Option<AmountView>,
    
    #[serde(rename = "Attachments", skip_serializing_if = "Vec::is_empty", default)]
    pub attachments: Vec<ContractInvoiceActionAttachmentView>,
    
    #[serde(rename = "AutoAttest", skip_serializing_if = "Option::is_none")]
    pub auto_attest: Option<bool>,
    
    #[serde(rename = "AutoMerge", skip_serializing_if = "Option::is_none")]
    pub auto_merge: Option<bool>,
    
    #[serde(rename = "AutogiroWithdrawalEnabled", skip_serializing_if = "Option::is_none")]
    pub autogiro_withdrawal_enabled: Option<bool>,
    
    #[serde(rename = "CommunicationLanguage", skip_serializing_if = "Option::is_none")]
    pub communication_language: Option<LanguageTypeView>,
    
    #[serde(rename = "ContractNumber", skip_serializing_if = "Option::is_none")]
    pub contract_number: Option<String>,
    
    #[serde(rename = "CreditCardWithdrawalEnabled", skip_serializing_if = "Option::is_none")]
    pub credit_card_withdrawal_enabled: Option<bool>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DebtCollectionDetails", skip_serializing_if = "Option::is_none")]
    pub debt_collection_details: Option<DebtCollectionDetailsView>,
    
    #[serde(rename = "DebtorPublicId", skip_serializing_if = "Option::is_none")]
    pub debtor_public_id: Option<Guid>,
    
    #[serde(rename = "DeliveryAddressOverride", skip_serializing_if = "Option::is_none")]
    pub delivery_address_override: Option<DeliveryAddressOverrideView>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "Events", skip_serializing_if = "Vec::is_empty", default)]
    pub events: Vec<ContractInvoiceActionEventView>,
    
    #[serde(rename = "ExternalReference", skip_serializing_if = "Option::is_none")]
    pub external_reference: Option<String>,
    
    #[serde(rename = "FreightFee", skip_serializing_if = "Option::is_none")]
    pub freight_fee: Option<AmountView>,
    
    #[serde(rename = "GenerateInvoicesOfActionType", skip_serializing_if = "Option::is_none")]
    pub generate_invoices_of_action_type: Option<ActionTypeView>,
    
    #[serde(rename = "InterestPercentage", skip_serializing_if = "Option::is_none")]
    pub interest_percentage: Option<f64>,
    
    #[serde(rename = "InterestStartInDaysAfterDueDate", skip_serializing_if = "Option::is_none")]
    pub interest_start_in_days_after_due_date: Option<i64>,
    
    #[serde(rename = "InterestType", skip_serializing_if = "Option::is_none")]
    pub interest_type: Option<InterestTypeView>,
    
    #[serde(rename = "InvoiceFee", skip_serializing_if = "Option::is_none")]
    pub invoice_fee: Option<AmountView>,
    
    #[serde(rename = "InvoicePeriod", skip_serializing_if = "Option::is_none")]
    pub invoice_period: Option<ContractInvoicePeriodRuleTypeView>,
    
    #[serde(rename = "InvoicePeriodMonthsOffset", skip_serializing_if = "Option::is_none")]
    pub invoice_period_months_offset: Option<i64>,
    
    #[serde(rename = "Message", skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    
    #[serde(rename = "OurReference", skip_serializing_if = "Option::is_none")]
    pub our_reference: Option<String>,
    
    #[serde(rename = "PaymentOverride", skip_serializing_if = "Option::is_none")]
    pub payment_override: Option<PaymentOverrideView>,
    
    #[serde(rename = "PaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "ReasonForHigherInterest", skip_serializing_if = "Option::is_none")]
    pub reason_for_higher_interest: Option<String>,
    
    #[serde(rename = "Records", skip_serializing_if = "Vec::is_empty", default)]
    pub records: Vec<ContractInvoiceActionRecordView>,
    
    #[serde(rename = "RecurrenceDetails", skip_serializing_if = "Option::is_none")]
    pub recurrence_details: Option<RecurrenceDetailsView>,
    
    #[serde(rename = "ReminderInvoiceDetails", skip_serializing_if = "Option::is_none")]
    pub reminder_invoice_details: Option<ReminderInvoiceDetailsView>,
    
    #[serde(rename = "ReverseVATDetails", skip_serializing_if = "Option::is_none")]
    pub reverse_vat_details: Option<ReverseVATDetailsView>,
    
    #[serde(rename = "RotRutDetails", skip_serializing_if = "Option::is_none")]
    pub rot_rut_details: Option<RotRutDetailsView>,
    
    #[serde(rename = "SendByMailIfEmailNotViewedInDays", skip_serializing_if = "Option::is_none")]
    pub send_by_mail_if_email_not_viewed_in_days: Option<i64>,
    
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<ContractInvoiceActionStateView>,
    
    #[serde(rename = "VatIsIncluded", skip_serializing_if = "Option::is_none")]
    pub vat_is_included: Option<bool>,
    
    #[serde(rename = "YourReference", skip_serializing_if = "Option::is_none")]
    pub your_reference: Option<String>,
    
}