
use crate::models::BankAccountBankTypeView; 
use crate::models::BankAccountStatusTypeView; 
use crate::models::BankAccountView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct BankAccountRequestView {
    
    #[serde(rename = "AccountNumbers", skip_serializing_if = "Vec::is_empty", default)]
    pub account_numbers: Vec<BankAccountView>,
    
    #[serde(rename = "Bank", skip_serializing_if = "Option::is_none")]
    pub bank: Option<BankAccountBankTypeView>,
    
    #[serde(rename = "BankIdAutostartToken", skip_serializing_if = "Option::is_none")]
    pub bank_id_autostart_token: Option<String>,
    
    #[serde(rename = "FailureCode", skip_serializing_if = "Option::is_none")]
    pub failure_code: Option<String>,
    
    #[serde(rename = "FailureMessage", skip_serializing_if = "Option::is_none")]
    pub failure_message: Option<String>,
    
    #[serde(rename = "IsBankIdAutostartTokenRequired", skip_serializing_if = "Option::is_none")]
    pub is_bank_id_autostart_token_required: Option<bool>,
    
    #[serde(rename = "PublicId", skip_serializing_if = "Option::is_none")]
    pub public_id: Option<String>,
    
    #[serde(rename = "QR", skip_serializing_if = "Option::is_none")]
    pub qr: Option<String>,
    
    #[serde(rename = "SSN", skip_serializing_if = "Option::is_none")]
    pub ssn: Option<String>,
    
    #[serde(rename = "Status", skip_serializing_if = "Option::is_none")]
    pub status: Option<BankAccountStatusTypeView>,
    
}