use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum ActionSourceTypeView {
    
    DebtCollectionAction,
    InvoiceAction,
    None,
    ReconciliationInvoiceAction,

}


impl fmt::Display for ActionSourceTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}