
use crate::models::AccountingSettingsAccountView; 
use crate::models::BookKeepingMethodView; 
use crate::models::DateTime; 
use crate::models::FiscalYearTypeView; 
use crate::models::Guid; 
use crate::models::SieKPTYPTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct AccountingSettingsView {
    
    #[serde(rename = "Accounts", skip_serializing_if = "Vec::is_empty", default)]
    pub accounts: Vec<AccountingSettingsAccountView>,
    
    #[serde(rename = "AccrualIsEnabled", skip_serializing_if = "Option::is_none")]
    pub accrual_is_enabled: Option<bool>,
    
    #[serde(rename = "BookKeepingMethod", skip_serializing_if = "Option::is_none")]
    pub book_keeping_method: Option<BookKeepingMethodView>,
    
    #[serde(rename = "CostCenterIsRequired", skip_serializing_if = "Option::is_none")]
    pub cost_center_is_required: Option<bool>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DefaultAutogiroPaymentCode", skip_serializing_if = "Option::is_none")]
    pub default_autogiro_payment_code: Option<String>,
    
    #[serde(rename = "DefaultBankgiroPaymentCode", skip_serializing_if = "Option::is_none")]
    pub default_bankgiro_payment_code: Option<String>,
    
    #[serde(rename = "DefaultCreditCardPaymentCode", skip_serializing_if = "Option::is_none")]
    pub default_credit_card_payment_code: Option<String>,
    
    #[serde(rename = "DefaultCreditingPaymentCode", skip_serializing_if = "Option::is_none")]
    pub default_crediting_payment_code: Option<String>,
    
    #[serde(rename = "DefaultFinancialPaymentCode", skip_serializing_if = "Option::is_none")]
    pub default_financial_payment_code: Option<String>,
    
    #[serde(rename = "DefaultSwishPaymentCode", skip_serializing_if = "Option::is_none")]
    pub default_swish_payment_code: Option<String>,
    
    #[serde(rename = "DisableBookkeepingOverPayments", skip_serializing_if = "Option::is_none")]
    pub disable_bookkeeping_over_payments: Option<bool>,
    
    #[serde(rename = "DisableBookkeepingUnmatchedPayments", skip_serializing_if = "Option::is_none")]
    pub disable_bookkeeping_unmatched_payments: Option<bool>,
    
    #[serde(rename = "ExtendedFirstFiscalYearStartDate", skip_serializing_if = "Option::is_none")]
    pub extended_first_fiscal_year_start_date: Option<DateTime>,
    
    #[serde(rename = "FiscalYear", skip_serializing_if = "Option::is_none")]
    pub fiscal_year: Option<FiscalYearTypeView>,
    
    #[serde(rename = "LockPreviousPeriodsAtDay", skip_serializing_if = "Option::is_none")]
    pub lock_previous_periods_at_day: Option<i64>,
    
    #[serde(rename = "ProjectIsRequired", skip_serializing_if = "Option::is_none")]
    pub project_is_required: Option<bool>,
    
    #[serde(rename = "RestingVatIsEnabled", skip_serializing_if = "Option::is_none")]
    pub resting_vat_is_enabled: Option<bool>,
    
    #[serde(rename = "SieKPTYP", skip_serializing_if = "Option::is_none")]
    pub sie_kptyp: Option<SieKPTYPTypeView>,
    
    #[serde(rename = "UsageOfUnmatchedPaymentIsBookedOnIncomingPaymentDate", skip_serializing_if = "Option::is_none")]
    pub usage_of_unmatched_payment_is_booked_on_incoming_payment_date: Option<bool>,
    
    #[serde(rename = "VoucherSeries", skip_serializing_if = "Option::is_none")]
    pub voucher_series: Option<String>,
    
}