use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     CreatedUrlView,
     CreatedView,
     CreditorKycView,
     CreditorShareView,
     CreditorSharesView,
     CreditorSubsView,
     CreditorTokenView,
     CreditorView,
     CreditorsView,
     DefaultActionConfigView,
     Guid,
     InvoiceTextTemplatesView,
     StreamView,
    
};


impl Client {
    
    

/// 
pub async fn creditors_create_a_creditor(&self,body: CreditorView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("creditor"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// A creditor sign in token enabled users in you site to be able to be signed in into Billecta App (https://app.billecta.com), a so called seamless sing in between our and your system. The call creates a key that is valid for one minute. For more information on how to integrate your application with Billecta App and set proper access rights please contact tech@billecta.com.
/// - **id**: Creditor public id
/// - **username**: Username to impersonate
pub async fn creditors_create_creditor_single_sign_in_token(&self,id: Guid,
                         username: Option<String>,
                         
) -> Result<CreditorTokenView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("creditortoken"))
        .url(Param::value(id))
        .query("username", Param::opt(username))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Creates or updates the KYC information for the creditor. Mobil BankID sign is optional
pub async fn creditors_create_or_update_kyc_information(&self,body: CreditorKycView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("kyc"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Deletes a creditor. Note that a creditor can't be deleted if an invoice, debtor, product, etc has been created on it. This is due to bookkeeping regulations.
/// - **id**: Creditor public id
pub async fn creditors_delete_a_creditor(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("creditor"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Deletes a saved text template.
/// - **creditorpublicid**: Creditor public id
/// - **invoicetexttemplatepublicid**: Invoice text template public id
pub async fn creditors_delete_a_text_template(&self,creditorpublicid: Guid,
                         invoicetexttemplatepublicid: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("creditortexttemplate"))
        .query("creditorpublicid", Param::value(creditorpublicid))
        .query("invoicetexttemplatepublicid", Param::value(invoicetexttemplatepublicid))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// 
/// - **id**: Creditor public id
pub async fn creditors_get_a_creditor(&self,id: Guid,
                         
) -> Result<CreditorView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("creditor"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get all creditors current user has read access to
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn creditors_get_all_creditors(&self,offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<CreditorsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("creditors"))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get all creditors that has been shared to the current calling user.
pub async fn creditors_get_all_shared_creditors_to_current_api_user(&self,
) -> Result<CreditorSharesView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("shares"))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get all users/shares that the specified creditor has been shared with.
/// - **id**: Creditor public id
pub async fn creditors_get_all_shares_on_creditor(&self,id: Guid,
                         
) -> Result<CreditorSharesView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("shares"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get a subset of all creditors info that current user has read access to
pub async fn creditors_get_creditors_subset_of_information(&self,
) -> Result<CreditorSubsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("creditorsubs"))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Gets the status of the KYC request. Request is made through the portal in company settings
/// - **id**: Creditor public id
pub async fn creditors_get_creditors_kyc_information(&self,id: Guid,
                         
) -> Result<CreditorKycView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("kyc"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Default configuration is a set of default values that has been defined by you or the users. They are just a suggestion and a default setting. When creating invoice or 'other' data the value should be extracted from the default values and sent with the actual invoice or the 'other' data.
/// - **id**: Creditor public id
pub async fn creditors_get_default_configuration(&self,id: Guid,
                         
) -> Result<DefaultActionConfigView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("defaultactionconfig"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// 
/// - **id**: Invoice text template by creditor public id
pub async fn creditors_get_invoice_text_templates(&self,id: Guid,
                         
) -> Result<InvoiceTextTemplatesView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("creditortexttemplate"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Sharing a creditor means that you can grant access (you define which rights) to another user in Billecta. By that you can for instance grant you bookkeeping firm access to your creditor as long as they have an account in Billecta. An alternative and more restrictive (for you bookkeeping firm) is that you create a specific user account for your bookkeeping firm in your domain. The reason why that is more restrictive for your bookkeeping firm is that the must have on account for each company that manage in Billecta.
pub async fn creditors_share_a_creditor(&self,
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("shares"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Unshare a creditor. All users that have been granted access directly or indirectly will be lose access to the creditor.
/// - **id**: Share public id
pub async fn creditors_unshare_a_creditor(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("shares"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// 
pub async fn creditors_update_a_creditor(&self,body: CreditorView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("creditor"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Valid format on logos are png, jpg, bmp. Image is stored in Billecta database if method is used. Alternative method for updating logo is to send your own URL when creating/updating creditor.
/// - **id**: Creditor public id
pub async fn creditors_update_creditor_logo(&self,id: Guid,
                         body: StreamView,
                         
) -> Result<CreatedUrlView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("logotype"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Update the rights on an already existing creditor share.
pub async fn creditors_update_creditor_share(&self,body: CreditorShareView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("shares"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// 
pub async fn creditors_update_default_configuration(&self,body: DefaultActionConfigView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("creditors"))
        .url(Param::value("defaultactionconfig"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
}