use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     Base64,
     CommentActionView,
     ContractInvoiceActionSubsView,
     ContractInvoiceActionView,
     CreatedView,
     DateTime,
     Guid,
     HalfYearlyAutogiroContractInvoiceView,
     InvoiceActionSubsView,
     MonthlyAutogiroContractInvoiceView,
     YearlyAutogiroContractInvoiceView,
    
};


impl Client {
    
    

/// 
pub async fn contract_invoice_comment_a_contract_invoice(&self,body: CommentActionView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("comment"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Create a new contract invoice. Response is the public id you will use when retrieving it again or performing actions on the contract invoice in the API.
pub async fn contract_invoice_create_a_contract_invoice(&self,body: ContractInvoiceActionView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("action"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Create a new contract invoice set to half year recurring. Create debtor with autogiro enabled. Response is the public id you will use when retrieving it again or performing actions on the contract invoice in the API.
pub async fn contract_invoice_create_half_year_recurring_autogiro_contract_invoice(&self,body: HalfYearlyAutogiroContractInvoiceView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("halfyearlyrecurringautogiro"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Create a new contract invoice set to monthly recurring. Create debtor with autogiro enabled. Response is the public id you will use when retrieving it again or performing actions on the contract invoice in the API.
pub async fn contract_invoice_create_monthly_recurring_autogiro_contract_invoice(&self,body: MonthlyAutogiroContractInvoiceView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("monthlyrecurringautogiro"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Create a new contract invoice set to yearly recurring. Create debtor with autogiro enabled. Response is the public id you will use when retrieving it again or performing actions on the contract invoice in the API.
pub async fn contract_invoice_create_yearly_recurring_autogiro_contract_invoice(&self,body: YearlyAutogiroContractInvoiceView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("yearlyrecurringautogiro"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Deletes a contract invoice. Please note that a contract invoice can't be deleted if at least on invoice is generated from it. Pause it (equal to disabling it) if it shall not be used anymore. You will get a 400 Bad Request it you try to delete a contract invoice that has been triggered at least once.
/// - **id**: Contract invoice action public id
pub async fn contract_invoice_delete_a_contract_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("action"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Creates a new invoice with the contract invoice as template. The response is the public id of the newly created invoice and the new invoice is retrieved using the Invoice endpoints.
/// - **id**: Contract invoice action public id
pub async fn contract_invoice_generate_a_new_invoice_from_a_contract_invoice(&self,id: String,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("createinvoice"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get a contract invoice based on the public id number that contract invoice was assigned when created.
/// - **id**: Contract invoice action public id
pub async fn contract_invoice_get_a_contract_invoice(&self,id: String,
                         
) -> Result<ContractInvoiceActionView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("action"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get all contract invoices for all debtors/customers
/// - **id**: Creditor public id
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn contract_invoice_get_all_contract_invoices(&self,id: Guid,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<ContractInvoiceActionSubsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("actions"))
        .url(Param::value(id))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get all contract invoices that to the specified debtor/customer
/// - **id**: Creditor public id
/// - **debtorpublicid**: Debtor public id
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn contract_invoice_get_all_contract_invoices_to_a_debtor(&self,id: Guid,
                         debtorpublicid: Guid,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<ContractInvoiceActionSubsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("actionsbydebtor"))
        .url(Param::value(id))
        .query("debtorpublicid", Param::value(debtorpublicid))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Gets all generated invoices by this contract invoice.
/// - **id**: Contract invoice action public id
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn contract_invoice_get_invoices_generated_from_contract_invoice(&self,id: String,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<InvoiceActionSubsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("generatedinvoices"))
        .url(Param::value(id))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Skips or reverts a contract invoice so that it is 'not triggered'/'retriggered' on the next run depending on recurring period setup. Please note that if you revert multiple steps to a date that is multiple periods earlier than current date, then the contract invoice will execute that many numbers of times until next step is after current date.
/// - **id**: Contract invoice action public id
/// - **steps**: Number of periods to move back or forward
pub async fn contract_invoice_move_next_run(&self,id: String,
                         steps: i64,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("movenextrun"))
        .url(Param::value(id))
        .query("steps", Param::value(steps))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Pauses/Disables a contract invoice from automatically creating new invoices each triggered period
/// - **id**: Contract invoice action public id
pub async fn contract_invoice_pause_disables_a_contract_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("pause"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Preview a contract invoice to view how it will be generated when the next period is triggered. This endpoint previews data already stored in API/database
/// - **id**: Contract invoice action public id
pub async fn contract_invoice_preview_a_contract_invoice_by_id(&self,id: String,
                         
) -> Result<Base64> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("preview"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Preview a contract invoice to view how it will be generated when the next period is triggered. This endpoint previews data sent in the request and ignores data stored in the API/database.
pub async fn contract_invoice_preview_a_contract_invoice(&self,body: ContractInvoiceActionView,
                         
) -> Result<Base64> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("preview"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Resumes/Enables a contract invoice to automatically create new invoices when each period is triggered.
/// - **id**: Contract invoice action public id
/// - **nextdate**: The earliest date when next invoice will be created
pub async fn contract_invoice_resume_a_contract_invoice(&self,id: String,
                         nextdate: DateTime,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("resume"))
        .url(Param::value(id))
        .query("nextdate", Param::value(nextdate))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// 
/// - **id**: Contract invoice action public id
pub async fn contract_invoice_update_a_contract_invoice(&self,id: String,
                         body: ContractInvoiceActionView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("contractinvoice"))
        .url(Param::value("action"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
}