use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     BankAccountBankTypeView,
     BankAccountRequestView,
     CreatedView,
     Guid,
    
};


impl Client {
    
    

/// Once a bank account retrieval is initiated the following method must be called until state has been set to Success or Failed.
/// - **id**: Request public id - retrieved from 'Initiate retrieval of bank account numbers' -
pub async fn bank_get_bank_account_numbers_retrieval_status(&self,id: Guid,
                         
) -> Result<BankAccountRequestView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("bank"))
        .url(Param::value("accounts"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Initiate a request to retrieve bank account numbers. This request starts a process where users are asked to identify themselves with BankID (you do not need to make a separate BankID request for this, the bank does this).     
/// - **id**: Creditor public Id for whom to request for
/// - **bank**: Bank where the person is customer
/// - **ssn**: The person whom to get bank number for
pub async fn bank_initiate_retrieval_of_bank_account_numbers(&self,id: String,
                         bank: BankAccountBankTypeView,
                         ssn: String,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("bank"))
        .url(Param::value("accounts"))
        .url(Param::value(id))
        .query("bank", Param::value(bank))
        .query("ssn", Param::value(ssn))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
}