//! A batch prediction of missing values from a data set.

use serde::{Deserialize, Serialize};

use super::id::*;
use super::status::*;
use super::{Resource, ResourceCommon};

/// A batch prediction generated by BigML.
///
/// TODO: Still lots of missing fields.
#[derive(Clone, Debug, Deserialize, Resource, Serialize)]
#[api_name = "batchprediction"]
#[non_exhaustive]
pub struct BatchPrediction {
    /// Common resource information. These fields will be serialized at the
    /// top-level of this structure by `serde`.
    #[serde(flatten)]
    pub common: ResourceCommon,

    /// The ID of this resource.
    pub resource: Id<BatchPrediction>,

    /// The status of this source.
    pub status: GenericStatus,

    /// Does this prediction include all the fields in the input?
    pub all_fields: bool,

    // Our output dataset.
    //pub output_dataset_resource: Option<Id<Dataset>>,
    /// Is our output dataset currently available?
    pub output_dataset_status: bool,
}
