use anyhow::*;
use std::time::Instant;
use bi_directional_pipe::pipe;
use tokio::task::JoinHandle;


#[tokio::main]
async fn main()->Result<()> {

    let start=Instant::now();

    let (left,right)=pipe();

    let join:JoinHandle<Result<()>>= tokio::spawn(async move{
        for i in 0..1000000 {
            right.send(i);
            let ok=right.recv().await?;
            ensure!(ok==i+1,"left return v error!!")
        }
        Ok(())
    });


    loop {
        if let Ok(v)=left.recv().await{
            left.send(v+1);
        }else {
            break;
        }
    }

    join.await??;

    println!("time {}ms",start.elapsed().as_millis());

    Ok(())
}