use bgpkit_parser::BgpkitParser;

/// This example shows how to download and process a single BGP archive file with BGPKIT Parser.
fn main() {
    env_logger::Builder::from_env(env_logger::Env::default().default_filter_or("info")).init();

    log::info!("downloading updates file");

    let file_name = "bview.20211101.0000.gz";
    // create a parser that takes the buffered reader
    let parser = BgpkitParser::new(file_name).unwrap();

    log::info!("parsing rib file: {}", file_name);
    // iterating through the parser. the iterator returns `BgpElem` one at a time.
    let mrt_count = parser.into_elem_iter().collect::<Vec<_>>().len();
    log::info!("total of {} bgp elems in {}", mrt_count, file_name);
    log::info!("done");
}