mod lib;
use lib::{Config, Converter};

use std::fs;
use std::io::Error;

fn main() -> Result<(), Error> {
    println!("Stating BFOM converter.");
    let converter_config = converter_get_config();
    let mut converter = Converter::new(converter_config);
    converter.convert()?;

    println!("Finished BFOM converter.");
    Ok(())
}

fn converter_get_config() -> Option<Config> {
    println!("Searching for .md.toml file");
    if let Ok(config_file) = fs::read_to_string(".md.toml") {
        if let Ok(config) = toml::from_str::<Config>(&*config_file) {
            println!("Found .md.toml, overriding defaults.");
            // the config file overrides teh defaults
            return Some(config);
        }
    }

    println!("No .md.toml file, using defaults.");
    None
}
