mod lib;
use lib::{Config, Converter};

use std::fs;
use std::io::Error;

fn main() -> Result<(), Error> {
    let converter_config = converter_get_config();
    let mut converter = Converter::new(converter_config);
    converter.convert()?;

    Ok(())
}

fn converter_get_config() -> Option<Config> {
    if let Ok(config_file) = fs::read_to_string(".md.toml") {
        if let Ok(config) = toml::from_str::<Config>(&*config_file) {
            // the config file overrides teh defaults
            return Some(config);
        }
    }

    None
}
