# Background

In the summer before I headed back to college I was itching for a project to do, something to do with rust.  
I had also recently acquired brendan.ie and had n o public accessible site on it.

So I decided to get two birds with one stone and create the site using rust.  
My original idea was to create a rust webserver, but I threw that out due to the complexities involved and my
relative lack of knowledge to the inner workings of http/tls.

Then it dawned on me, I use markdown pretty often, on readme's (like this), reddit, discord, gitlab wiki.  
Markdown is designed to be both human-readable and can be converted into html.  
Tt is also the type of thing rust is pretty good at, cli stuff, text manipulation etc.

It was perfect!  
What could go wrong?

## What could go wrong?

As soon as that thought appeared in my head I should have binned the whole idea, a red flag waving a red flag, alas I didn't.

So I started looking into existing implementations, [Daring Fireball], [Github], [Reddit] and [Discord].  
All seemed to be roughly the same, few minor differences between them.  
Learnt quite a bit actually, like how amazing reference links are.

Then a friend pointed me to [Commonmark] and that is the point where things went downhill.

Commonmark is quite good, they have taken on the task of unifying the existing implementations and providing many many test cases (649 in v0.29, 652 in v0.30).  
However, as far as I can tell from reading both the changelog, and the forums they are really averse to breaking changes.  
This would be grand if there were not underlying structural issues.

[Daring Fireball]: https://daringfireball.net/projects/markdown/
[Github]: https://github.github.com/gfm/
[Reddit]: https://www.reddit.com/wiki/markdown
[Discord]: https://support.discord.com/hc/en-us/articles/210298617-Markdown-Text-101-Chat-Formatting-Bold-Italic-Underline-
[Commonmark]: https://spec.commonmark.org/0.30/

## Issues with existing implementations.

### Code
Code can be done at a span or block level.  
Three of the implementations use backticks \`, the fourth uses spaces.

#### Spans

In the original code spans were denoted by \`code\` except in cases that a backtick is within it then using \`\`co\`de\`\` is acceptable.  
Not great that the markdown identifier changed based on its contents, but still workable.

#### Blocks

In the original version of markdown the way to create a code block was to indent the text four times.   
The second way is to use fenced code blocks, starting a line with "\`\`\` <language>" and on the line after the code using "\`\`\`"

#### Issues
For spans the fact that the delimiter changed depending ont eh contents was not ideal.  
Anyone that knows me on discord would have heard of this as I have often complained that the Desktop and Mobile versions follow different specs.  
The Desktop accepts both one and two backticks, Mobile only accepts one backtick.

For blocks the indentation introduces an immense amount of complexity to deciphering other block level content, specifically headers and lists.  
Headers can be indented 3 times for presentation, so you can align a h1 with a h4, however you cannot get a h1 and h6 to align on the page like so

```
Valid:
   # h1
#### h4

Not Valid:
     # h1 
###### h6
```

The issue is even deeper for lists as they have an inherent indentation of at least 3 spaces.


### Lazy Continuation
In teh current specs Block quotes and Lists have the idea of laziness where you can omit the leading delimiter: [block quote][Commonmark lazy block] [lists][Commonmark lazy list].

The concept behind it is to make it easier to write up documents, however combined with the spacing issue mentioned above they add an immense amount of complexity to parsing it.  
It is also my opinion that it goes against the "easy-to-read" principle of the original.

```
Lazy:

25. List item Line 1 of Paragraph
List item Line 2 of Paragraph
List item Line 3 of Paragraph
26. Next item

Non Lazy:

25. List item Line 1 of Paragraph
    List item Line 2 of Paragraph
    List item Line 3 of Paragraph
26. Next item

```

It can also lead to other inconsistencies.  
Take a look at [nestled lazy block quotes][Commonmark lazy block 2]

```
>>> foo
> bar
>> baz
```
The expectation from reading the markdown is that the first line is in 3 block, second in one and the third in two.  
In reality, it creates a triple blockquote with `foo bar baz` in a line.

To get the expected output you would have to do:

```
>>> foo
>
> bar
>
>> baz
```



[Commonmark lazy block]: https://spec.commonmark.org/0.30/#example-232
[Commonmark lazy block 2]: https://spec.commonmark.org/0.30/#example-251
[Commonmark lazy list]: https://spec.commonmark.org/0.30/#example-290


### HTML
In the original no markdown in html blocks is allowed, but it is allowed in inline html.  
In commonmark markdown is allowed in both blocks and inline.

Doing markdown in html is tricky, at least to do it properly.  
You have to ensure that the html can actually accept html inside it.  
If you assume wrong you can break both teh assumptions of the user along with teh HTML spec itself.

A good example of how not to do it is [Commonmark again][Commonmark broke me].


Input:
```
<table><tr><td>
<pre>
**Hello**,

_world_.
</pre>
</td></tr></table>
```

Result:
```
<table><tr><td>
<pre>
**Hello**,
<p><em>world</em>.
</pre></p>
</td></tr></table>
```

This is a html block that contains preformatted text.  
Because of the space in teh middle commonmark deemed it the end of the internal content and so began to apply markdown from there on.

This breaks the user's assumption that preformatted text will remain preformatted.  
Secondly the html generated actually breaks the html spec there is a closing pre tag in the pargaraph, but not an opening, likewise the original opening pre is unclosed.


[Commonmark broke me]: https://spec.commonmark.org/0.30/#example-148



# Conclusion
By this point I was far too deep down the rabbit-hole, so I ended up creating my own spec.

Head over to the [adjacent file][Sanity?] to see the breaking changes and additions I made


[Sanity?]: ./Breaking_Changes.md