use bevy::prelude::*;
use bevy_plot::*;

use std::collections::HashMap;

fn main() {
    App::new()
        .insert_resource(WindowDescriptor {
            width: 1000.,
            height: 800.,
            ..Default::default()
        })
        .add_plugins(DefaultPlugins)
        .add_plugin(PlotPlugin)
        .add_startup_system(setup)
        .run();
}

fn setup(
    mut commands: Commands,
    colors_res: Res<HashMap<PlotColor, Vec<Color>>>,
    mut plots: ResMut<Assets<Plot>>,
) {
    commands.spawn_bundle(OrthographicCameraBundle::new_2d());

    let mut plot = Plot::default();

    plot.canvas_size = Vec2::new(777.0, 555.0);
    plot.canvas_position = Vec2::new(-77.0, 0.0);
    plot.hide_half_ticks = true;
    plot.significant_digits = 2;
    plot.show_target = true;
    plot.show_grid = false;

    let colors = colors_res.as_ref();
    plot.tick_label_color = colors.get(&PlotColor::Black).unwrap()[5];
    plot.background_color1 = colors.get(&PlotColor::Cream).unwrap()[1];
    plot.background_color2 = colors.get(&PlotColor::Cream).unwrap()[2] * 0.8;

    let lower_bound = Vec2::new(-0.2, -0.2);
    let upper_bound = Vec2::new(1.0, 1.0);

    plot.set_bounds(lower_bound, upper_bound);

    let ys: Vec<(f32, f32)> = vec![
        (0.040031026908292355, 0.4034227550744621),
        (0.04649615595826484, 0.4157128539082504),
        (0.0525282811641955, 0.4265382422638997),
        (0.056560406370126326, 0.4061728335857745),
        (0.05839319055464032, 0.43630030088215466),
        (0.06462465678198792, 0.4077323006482807),
        (0.06462465678198792, 0.44591188460841347),
        (0.07158923668314116, 0.45572284756656734),
        (0.07268890719384952, 0.40920969049697087),
        (0.07892037342119718, 0.46502219589193383),
        (0.08075315760571117, 0.4104818873111209),
        (0.08625151015925314, 0.47481811136088803),
        (0.08881740801757276, 0.41171304551836274),
        (0.09394920373421195, 0.4838999550696419),
        (0.09688165842943436, 0.4129442037256046),
        (0.1020134541460736, 0.4923949466996106),
        (0.10494590884129601, 0.4139291302913979),
        (0.11007770455793525, 0.5003974750466824),
        (0.11301015925315766, 0.41487301825028344),
        (0.11814195496979679, 0.5078665015039496),
        (0.1210744096650192, 0.41573482899535263),
        (0.12620620538165844, 0.514925141892136),
        (0.12913866007688085, 0.41643248531278965),
        (0.1342704557935201, 0.5214913189974257),
        (0.1372029104887425, 0.41717118023713473),
        (0.14233470620538163, 0.5277702258543591),
        (0.14526716090060404, 0.4177867593407556),
        (0.15039895661724328, 0.5335566694283957),
        (0.1533314113124657, 0.4180740295891121),
        (0.15846320702910494, 0.5391379199678921),
        (0.16139566172432734, 0.418648570085825),
        (0.16652745744096648, 0.54447293886594),
        (0.16945991213618888, 0.4189768789410895),
        (0.17459170785282813, 0.5494386103018153),
        (0.17165925315760572, 0.05440631061263901),
        (0.17147597473915427, 0.03729731539266834),
        (0.17459170785282813, 0.06939360985546283),
        (0.17679104887424496, 0.02566287033423298),
        (0.17752416254805053, 0.4189768789410895),
        (0.17935694673256447, 0.07944909451311044),
        (0.18265595826468978, 0.5540349342755182),
        (0.1818274299835257, 0.6730336707577802),
        (0.1848552992861065, 0.020779276112173783),
        (0.18558841295991219, 0.4189768789410895),
        (0.18632152663371776, 0.08771324397922131),
        (0.19072020867655132, 0.5584671038215887),
        (0.1924565305355646, 0.680745154512709),
        (0.19291954969796815, 0.020204735615460878),
        (0.19365266337177373, 0.4189768789410895),
        (0.1943857770455793, 0.09337657173253366),
        (0.19878445908841297, 0.6638542463614894),
        (0.19878445908841297, 0.5626120031193029),
        (0.2009838001098298, 0.6856457466296697),
        (0.2009838001098298, 0.020820314719081856),
        (0.20171691378363538, 0.4189768789410895),
        (0.20245002745744095, 0.09686485331971884),
        (0.20684870950027462, 0.6596683084568671),
        (0.20684870950027462, 0.5665517093824768),
        (0.20904805052169134, 0.6902420706033725),
        (0.20904805052169134, 0.021641086857243086),
        (0.20978116419549703, 0.41885376312036526),
        (0.2105142778693026, 0.09920405391347842),
        (0.21491295991213616, 0.6554413319453368),
        (0.21491295991213616, 0.5702862226111103),
        (0.217112300933553, 0.694592162935627),
        (0.217112300933553, 0.022297704567772136),
        (0.21784541460735857, 0.4181150681960202),
        (0.21857852828116414, 0.10117390704506524),
        (0.2229772103239978, 0.6512553940407146),
        (0.2229772103239978, 0.5738155428052035),
        (0.22517655134541464, 0.6987781008402492),
        (0.22517655134541464, 0.023077438099025183),
        (0.22590966501922022, 0.417950913768388),
        (0.2266427786930258, 0.10330791460428446),
        (0.23104146073585946, 0.6470284175291843),
        (0.23104146073585946, 0.5770575927509403),
        (0.23324080175727618, 0.7026357298896069),
        (0.23324080175727618, 0.023980287451002558),
        (0.23397391543108187, 0.41717118023713473),
        (0.23470702910488744, 0.10560607659113586),
        (0.239105711147721, 0.6428835182314702),
        (0.239105711147721, 0.5801354882690449),
        (0.24130505216913783, 0.7062881659044244),
        (0.24130505216913783, 0.024883136802979933),
        (0.2420381658429434, 0.4165145625266058),
        (0.24277127951674898, 0.10806839300561943),
        (0.24716996155958265, 0.6386155031130318),
        (0.24716996155958265, 0.5830492293595173),
        (0.24936930258099949, 0.7096943702777934),
        (0.24936930258099949, 0.02586806336877323),
        (0.25010241625480506, 0.41573482899535263),
        (0.25083552992861063, 0.11053070942010312),
        (0.2552342119714443, 0.6345116424222257),
        (0.2552342119714443, 0.5857167388085412),
        (0.257433552992861, 0.712813304402806),
        (0.257433552992861, 0.026935067148382896),
        (0.2581666666666667, 0.4147909410364673),
        (0.2588997803404723, 0.11315718026221899),
        (0.26329846238330584, 0.6302436273037874),
        (0.26329846238330584, 0.5881380166161168),
        (0.2654978034047227, 0.7157680841001866),
        (0.2654978034047227, 0.02812518674871667),
        (0.26623091707852825, 0.4137649758637657),
        (0.2669640307523338, 0.11594780553196715),
        (0.2713627127951675, 0.6260987280060732),
        (0.2713627127951675, 0.5905182558167843),
        (0.2735620538165843, 0.7185176707630265),
        (0.2735620538165843, 0.02931530634905055),
        (0.2742951674903899, 0.41241070183579975),
        (0.2750282811641955, 0.11882050801553146),
        (0.27942696320702914, 0.6218717514945429),
        (0.27942696320702914, 0.5926522633760035),
        (0.28162630422844587, 0.7210210257844183),
        (0.28162630422844587, 0.03046438734247625),
        (0.28235941790225155, 0.41122058223546587),
        (0.2830925315760571, 0.12189840353363612),
        (0.2874912136188907, 0.6176858135899207),
        (0.2874912136188907, 0.5946631551144985),
        (0.2896905546403075, 0.7233191877712697),
        (0.2896905546403075, 0.03198281579807438),
        (0.2904236683141131, 0.4096200765660516),
        (0.29115678198791867, 0.1250994148724648),
        (0.29555546403075234, 0.6134588370783904),
        (0.29555546403075234, 0.5964278152115452),
        (0.29775480505216917, 0.7253711181166728),
        (0.29775480505216917, 0.03329605121913237),
        (0.29848791872597474, 0.40806060950354517),
        (0.2992210323997803, 0.12842354203201767),
        (0.303619714442614, 0.6087530768195994),
        (0.303619714442614, 0.5980283208809596),
        (0.3058190554640307, 0.7273409712482597),
        (0.3058190554640307, 0.03477344106782265),
        (0.3065521691378363, 0.40621387219268246),
        (0.30728528281164197, 0.13195286222611102),
        (0.3116839648544755, 0.604102526551825),
        (0.31388330587589236, 0.7290645927383982),
        (0.31388330587589236, 0.03637394673723693),
        (0.31461641954969793, 0.4043260962749117),
        (0.3153495332235035, 0.13560529824092837),
        (0.31791543108182313, 0.6012521314458483),
        (0.321947556287754, 0.7305419825870885),
        (0.321947556287754, 0.03789237519283528),
        (0.3226806699615596, 0.40206897289496835),
        (0.32341378363536516, 0.13954500450410223),
        (0.33001180669961555, 0.7318141794012383),
        (0.33001180669961555, 0.03965703528988174),
        (0.3307449203734211, 0.3996887336943008),
        (0.3314780340472268, 0.14352574937418416),
        (0.3380760571114772, 0.732922221787756),
        (0.3380760571114772, 0.041421695386928414),
        (0.3388091707852828, 0.39718537867290904),
        (0.33954228445908835, 0.14787584170643864),
        (0.34614030752333885, 0.7339481869604575),
        (0.34614030752333885, 0.04322739409088305),
        (0.3468734211971444, 0.3943947534031609),
        (0.34760653487095, 0.15234904985941722),
        (0.3542045579352004, 0.7346458432778945),
        (0.3542045579352004, 0.045197247222470094),
        (0.35493767160900597, 0.3913578964919644),
        (0.35567078528281165, 0.15715056686766038),
        (0.36226880834706204, 0.735015190740067),
        (0.36226880834706204, 0.04716710035405702),
        (0.3630019220208676, 0.3880748079393195),
        (0.3637350356946732, 0.1621572769104438),
        (0.3703330587589237, 0.7357538856644121),
        (0.3703330587589237, 0.049177992092552025),
        (0.37106617243272927, 0.38450444913831827),
        (0.37179928610653484, 0.167615411629216),
        (0.37839730917078523, 0.7358770014851364),
        (0.37839730917078523, 0.05135303825867921),
        (0.3791304228445908, 0.38052370426823634),
        (0.3798635365183965, 0.17331977798943643),
        (0.3864615595826469, 0.7358770014851364),
        (0.3864615595826469, 0.0535280844248065),
        (0.38719467325645246, 0.37617361193598187),
        (0.38792778693025803, 0.17947556902564565),
        (0.39452580999450854, 0.7357949242713202),
        (0.39452580999450854, 0.055949362232382116),
        (0.3952589236683141, 0.3714952107484629),
        (0.3959920373421197, 0.18612382334475153),
        (0.4025900604063701, 0.7350562293469751),
        (0.4025900604063701, 0.05816544700541726),
        (0.40332317408017565, 0.3660370760296908),
        (0.40405628775398134, 0.1934697339812944),
        (0.4106543108182317, 0.7347279204917107),
        (0.4106543108182317, 0.06062776341990095),
        (0.4113874244920373, 0.36008647802802196),
        (0.4121205381658429, 0.2013901851145502),
        (0.4187185612300934, 0.7339892255673656),
        (0.4187185612300934, 0.06325423426201693),
        (0.41945167490389895, 0.3532330306743757),
        (0.4201847885777045, 0.2105828330619558),
        (0.4267828116419549, 0.7330453376084801),
        (0.4267828116419549, 0.06588070510413291),
        (0.4275159253157605, 0.34518946372039583),
        (0.4275159253157605, 0.21994875512741774),
        (0.43484706205381657, 0.7318962566150544),
        (0.4337473915431082, 0.22932208694134915),
        (0.43484706205381657, 0.06863029176697288),
        (0.43521361889071936, 0.3360050234943718),
        (0.4396123009335529, 0.23936628598209708),
        (0.4429113124656782, 0.7306650984078127),
        (0.44181164195496975, 0.326434820363412),
        (0.4429113124656782, 0.071461955643629),
        (0.44547721032399773, 0.25014405012132657),
        (0.446943437671609, 0.31665395238365734),
        (0.45097556287753976, 0.7291466699522143),
        (0.45097556287753976, 0.07433465812719331),
        (0.450609006040637, 0.2602258678850735),
        (0.45097556287753976, 0.30584985513832863),
        (0.45390801757276217, 0.293480819016239),
        (0.45427457440966496, 0.27124815372379696),
        (0.45500768808347064, 0.2812923527645449),
        (0.4590398132894014, 0.727505125675892),
        (0.4590398132894014, 0.07733047643148172),
        (0.46710406370126306, 0.7256173497581211),
        (0.46710406370126306, 0.08040837194958639),
        (0.4751683141131246, 0.723483342198902),
        (0.4751683141131246, 0.08360938328841516),
        (0.48323256452498625, 0.721472450460407),
        (0.48323256452498625, 0.08660520159270357),
        (0.4912968149368479, 0.7190101340459233),
        (0.4912968149368479, 0.0900114059660726),
        (0.49936106534870944, 0.7162605473830832),
        (0.49936106534870944, 0.09345864894634981),
        (0.507425315760571, 0.713428883506427),
        (0.507425315760571, 0.0970700463542592),
        (0.5154895661724328, 0.7102689107745063),
        (0.5154895661724328, 0.1008045595828927),
        (0.5235538165842943, 0.7069447836149534),
        (0.5235538165842943, 0.10466218863225041),
        (0.5211101043382758, 0.779364245272045),
        (0.5206213618890718, 0.7679281534803319),
        (0.5211101043382758, 0.7552882625526491),
        (0.5228207029104888, 0.7930574604437013),
        (0.5228207029104888, 0.7426483716249663),
        (0.5253866007688084, 0.804944976911403),
        (0.5253866007688084, 0.7306856177112666),
        (0.5286856123009336, 0.8158694540703288),
        (0.5286856123009336, 0.719715998084742),
        (0.5335616736366324, 0.7039198763245393),
        (0.5316180669961559, 0.10851981768160812),
        (0.5327177375068644, 0.8260866992368724),
        (0.5374829763866007, 0.8357708333574865),
        (0.5396823174080176, 0.1127057555862303),
        (0.5433478857770455, 0.8455731977503833),
        (0.5477465678198792, 0.11685065488394453),
        (0.5506790225151015, 0.8555045406221341),
        (0.5558108182317407, 0.121200747216199),
        (0.5587432729269632, 0.8646561499626317),
        (0.5638750686436025, 0.12575603258299384),
        (0.5668075233388248, 0.8721662150268068),
        (0.571939319055464, 0.13031131794978856),
        (0.5748717737506863, 0.8784040832768322),
        (0.5800035694673256, 0.13505127704766962),
        (0.5829360241625481, 0.8836159863541558),
        (0.5880678198791871, 0.1395860431110103),
        (0.5910002745744096, 0.8879660786864103),
        (0.5961320702910489, 0.14459275315379383),
        (0.5990645249862712, 0.8914953988805036),
        (0.6041963207029104, 0.15019452299674407),
        (0.6071287753981327, 0.8941218697226194),
        (0.612260571114772, 0.15587837005351057),
        (0.6151930258099945, 0.8961738000680225),
        (0.6203248215266337, 0.16133650477228267),
        (0.623257276221856, 0.8976922285236208),
        (0.6223775398132894, 0.8015141493738891),
        (0.62509006040637, 0.7857594281818845),
        (0.6261897309170785, 0.8173914001208049),
        (0.6283890719384952, 0.16699983252559503),
        (0.6313215266337175, 0.8983898848410579),
        (0.6313215266337175, 0.7763000292895764),
        (0.6327877539813289, 0.8259157050414221),
        (0.6364533223503568, 0.1729504305272639),
        (0.6393857770455793, 0.8983898848410579),
        (0.6393857770455793, 0.7704315085017237),
        (0.6408520043931905, 0.8309634536911137),
        (0.6445175727622185, 0.17918829877728915),
        (0.6474500274574408, 0.8981026145927014),
        (0.6474500274574408, 0.7683795781563206),
        (0.648916254805052, 0.8323177277190796),
        (0.6525818231740801, 0.18575447588257887),
        (0.6555142778693024, 0.8970356108130918),
        (0.6555142778693024, 0.769980083825735),
        (0.6569805052169138, 0.8301426815529525),
        (0.6606460735859416, 0.19236169159477678),
        (0.6635785282811641, 0.8952709507160452),
        (0.6635785282811641, 0.7752330255099669),
        (0.6650447556287753, 0.8238637746960191),
        (0.6687103239978034, 0.19929721616223894),
        (0.6716427786930257, 0.8928907115153777),
        (0.6698099945085116, 0.7837280171399355),
        (0.6709096650192201, 0.8146957499127583),
        (0.6731090060406368, 0.7932079353356976),
        (0.6738421197144424, 0.8034402279914408),
        (0.6767745744096649, 0.2065610495849659),
        (0.6797070291048872, 0.8897717773903651),
        (0.6848388248215265, 0.21411215325604904),
        (0.687771279516749, 0.8858731097340992),
        (0.6929030752333882, 0.22203260438930483),
        (0.6958355299286105, 0.8811536699396723),
        (0.7009673256452498, 0.2302813643778251),
        (0.7038997803404721, 0.8754082649725436),
        (0.7090315760571113, 0.239022587649242),
        (0.7119640307523338, 0.8685137790119895),
        (0.7170958264689731, 0.24805108116901542),
        (0.7200282811641954, 0.8602650190234692),
        (0.7251600768808346, 0.25781826961313403),
        (0.7254258649093901, 0.8542731364906561),
        (0.7328577704557935, 0.2675690426144892),
        (0.7361567819879187, 0.8550531159461454),
        (0.7401889071938494, 0.2775455279538389),
        (0.7442210323997802, 0.8550531159461454),
        (0.7411419549697966, 0.6929013723310149),
        (0.7423882482152662, 0.6765146565926261),
        (0.7434879187259746, 0.7089419958178123),
        (0.7460538165842943, 0.6653795145849056),
        (0.7471534870950027, 0.28751198163372216),
        (0.7460538165842943, 0.7191742884735555),
        (0.7489862712795166, 0.7293313436833007),
        (0.7522852828116418, 0.8546837684839729),
        (0.7511856123009335, 0.6553541249056571),
        (0.7544846238330587, 0.7419917539144374),
        (0.7533849533223502, 0.2970922164241484),
        (0.7570505216913783, 0.6457613505408979),
        (0.7603495332235035, 0.8536578033112714),
        (0.759249862712795, 0.3066285627044091),
        (0.7625488742449202, 0.749830127833877),
        (0.7629154310818231, 0.6357171515001501),
        (0.7651147721032399, 0.3169549021676499),
        (0.768413783635365, 0.8520162590349489),
        (0.768413783635365, 0.6256004020650467),
        (0.7706131246567818, 0.7584071966776618),
        (0.7706131246567818, 0.3272731804759623),
        (0.7735455793520043, 0.6156690591932961),
        (0.7764780340472266, 0.8498822514757297),
        (0.775744920373421, 0.3377204372631287),
        (0.7783108182317406, 0.7677927260775353),
        (0.7783108182317406, 0.6054152701244104),
        (0.7805101592531576, 0.34825367970286436),
        (0.7845422844590884, 0.8472968192405219),
        (0.7827095002745743, 0.5953334523606635),
        (0.7852753981328939, 0.7775585465680903),
        (0.784908841295991, 0.35893739703459626),
        (0.7867416254805051, 0.5849205898345249),
        (0.7889409665019218, 0.3699521591287198),
        (0.7926065348709499, 0.844013730687877),
        (0.7915068643602414, 0.7875651268858391),
        (0.7904071938495332, 0.5746281072219831),
        (0.792239978034047, 0.37959007596107797),
        (0.7937062053816584, 0.5643356246094415),
        (0.7951724327292695, 0.38952141883282865),
        (0.7970052169137836, 0.7975932036167304),
        (0.7966386600768807, 0.5538400008927049),
        (0.8006707852828114, 0.8401971402454274),
        (0.7981048874244918, 0.4005813233945511),
        (0.7992045579352003, 0.5434196146219663),
        (0.8017704557935199, 0.8075030500753388),
        (0.8006707852828114, 0.41205503390926324),
        (0.801403898956617, 0.5327358972902345),
        (0.8028701263042284, 0.424093025268961),
        (0.8032366831411311, 0.5221274174045007),
        (0.8058025809994507, 0.8170431582278994),
        (0.8045807248764414, 0.511518937518767),
        (0.804922844590884, 0.4369435810454385),
        (0.8117018121911039, 0.833955606187257),
        (0.8058025809994507, 0.49955618360506715),
        (0.8058690280065897, 0.4511296437566108),
        (0.8069022515101592, 0.4857877309874128),
        (0.8069022515101592, 0.475856388115662),
        (0.8069022515101592, 0.4659250452439112),
        (0.8087350356946732, 0.8243562379789158),
    ];

    plot.plotopt(
        ys,
        vec![
            Opt::Size(0.75),
            Opt::Color(colors.get(&PlotColor::Black).unwrap()[4]),
            Opt::LineStyle(LineStyle::None),
            Opt::Mech(false),
            Opt::MarkerStyle(MarkerStyle::Circle),
            Opt::MarkerSize(0.5),
            Opt::Contour(false),
            Opt::MarkerColor(colors.get(&PlotColor::Green).unwrap()[5]),
            Opt::MarkerInnerPointColor(colors.get(&PlotColor::Green).unwrap()[5]),
        ],
    );

    let plot_handle = plots.add(plot.clone());
    commands.spawn().insert(plot_handle);
}
