# Bevy fluent

[![crates.io](https://img.shields.io/crates/v/bevy_fluent.svg)](https://crates.io/crates/bevy_fluent)
[![docs.rs](https://docs.rs/bevy_fluent/badge.svg)](https://docs.rs/bevy_fluent)
[![license](https://img.shields.io/crates/l/bevy_fluent)](#license)
[![ci](https://github.com/kgv/bevy_fluent/workflows/ci/badge.svg)](https://github.com/kgv/bevy_fluent/actions)
[![bevy tracking](https://img.shields.io/badge/bevy%20tracking-main-yellow)](https://github.com/bevyengine/bevy/blob/master/docs/plugins_guidelines.md#master-branch-tracking)

[Bevy][bevy] plugin for localization using [Fluent][fluent].

## Documentation

[English 🇺🇸](doc/en-US.md) | [Русский 🇷🇺](doc/ru-RU.md)

## Version

| bevy | bevy_fluent       |
| ---- | ----------------- |
| main | main              |
| v0.5 | v0.2              |
| v0.4 | branch: bevy-v0.4 |

## Todo

- [ ] Checking localization load status using `LoadState`.

## See Also

- [Bevy][bevy] ❤️
- [Bevy localisation plugin issue][bevy-localisation-plugin-issue]

***

- [Fluent][fluent]
- [Fluent fallback][fluent-fallback]
- [Fluent language negotiation][fluent-langneg]
- [Fluent message format 2.0](fluent-message-format-2.0)
- [Fluent resource manager][fluent-resmgr]
- [L10nRegistry][l10nregistry]

***

- [Locales](https://github.com/unicode-org/cldr-json/blob/master/cldr-json/cldr-core/availableLocales.json)
- [Unicode Language Identifier][unicode-language-identifier]

## Dedication

Thanks to my little sister Anny ❤️ the world's best linguist and the most
wonderful sister.

[bevy]: https://github.com/bevyengine/bevy
[bevy-localisation-plugin-issue]: https://github.com/bevyengine/bevy/issues/461
[fluent]: https://github.com/projectfluent/fluent-rs
[fluent-fallback]: https://github.com/projectfluent/fluent-rs/tree/master/fluent-fallback
[fluent-langneg]: https://github.com/projectfluent/fluent-langneg-rs
[fluent-message-format-2.0]: https://github.com/zbraniecki/message-format-2.0-rs
[fluent-resmgr]: https://github.com/projectfluent/fluent-rs/tree/master/fluent-resmgr
[l10nregistry]: https://github.com/zbraniecki/l10nregistry-rs
[unicode-language-identifier]: http://unicode.org/reports/tr35/#Unicode_language_identifier
