# Examples

These examples are simple Bevy Apps illustrating the capabilities of `bevy_asset_loader`. Run the examples with `cargo run --example <example>`.

Example | Description
--- | ---
[`atlas_from_grid.rs`](atlas_from_grid.rs) | Loading a texture atlas from a sprite sheet
[`color_material.rs`](color_material.rs) | Loading a color material from a png file
[`dynamic_asset.rs`](dynamic_asset.rs) | Load a texture asset from a path resolved at run time
[`init_resource.rs`](init_resource.rs) | Inserting a `FromWorld` resource when all asset collections are loaded
[`two_collections.rs`](two_collections.rs) | Load multiple asset collections

## Credits
The example includes third party assets:

Background audio: [CC BY 3.0](https://creativecommons.org/licenses/by/3.0/) by [Jay_You](https://freesound.org/people/Jay_You/sounds/460432/)

Toon character sheets [CC0 1.0 Universal](https://creativecommons.org/publicdomain/zero/1.0/) by [Kenny](https://kenney.nl/assets/toon-characters-1)
