# Bevy-Embasset

[![Crate](https://img.shields.io/crates/v/bevy-embasset.svg)](https://crates.io/crates/bevy-embasset)
[![Release Doc](https://docs.rs/bevy-embasset/badge.svg)](https://docs.rs/bevy-embasset)
[![Test Status](https://github.com/taurr/bevy-embasset/actions/workflows/build_n_test.yml/badge.svg)](https://github.com/taurr/bevy-embasset/actions)

Embed your asset folder inside your binary.

`bevy-embasset` adds support for loading assets embedded into the binary.

Furthermore, it can optionally try to load assets via the default [`AssetPlugin`](bevy::asset::AssetPlugin)
first, thereby allowing the embedded assets to be used as fallbacks in case of problems.

As icing on the cake, `bevy-embasset` allows to register multiple other
[`AssetServer`](bevy::asset::AssetServer)'s, that will be used for asset paths beginning with
specific configurable strings. This can be used to have some assets load from e.g. a web-service,
while others are loaded from disk or embedded in the binary. It can also be used to e.g. build
1 or more sub-crates each using [`EmbassetIo`](EmbassetIo) and holding a set of assets - thereby
saving compile-time as the assets don't have to be compiled every time (An example of this, can be found in the
game [`bevoids`](https://github.com/taurr/bevoids)).

# Usage

If you are using the [`DefaultPlugins`](bevy::prelude::DefaultPlugins) group from Bevy, it can
easily be added this way:

```rust
use bevy::{prelude::*, asset::AssetPlugin};
use bevy_embasset::AddEmbassetPlugin;
fn main() {
  App::new().add_embasset_plugin(add_embasset_assets);
}
```

The `add_embasset_assets` function can be generated by a build script (`build.rs`):

```rust
use std::{env, path::Path};

fn main() {
    // Do this to include all files in the asset folder:
    bevy_embasset::include_all_assets(
        &Path::new(&env::var("CARGO_MANIFEST_DIR").unwrap()).join("assets"),
    );

    // OR this, just to make sure all your assets are accounted for:
    // if bevy_embasset::include_assets(
    //     &Path::new(&env::var("CARGO_MANIFEST_DIR").unwrap()).join("assets"),
    //     &[".keepme"],
    // )
    // .is_err()
    // {
    //     std::process::exit(-1);
    // }
}
```

and included in the source:

```rust
include!(concat!(env!("OUT_DIR"), "/add_embasset_assets.rs"));
```

For the build script, the feature `build` needs to be enabled:

```toml
[build-dependencies]
bevy-embasset = { version = "*", features = ["build"] }
```

## Features

### `use_default_assetio`

Try to use Bevy's default [`AssetIo`](bevy::asset::AssetIo) for handling assets first. In case this fails,
attempt to use the embedded resources.

### `build`

Needs to be enabled in order to get access to the `include_XXX` methods, needed from `build.rs` to
automatically include assets in the binary.

## Bevy Compatibility

|Bevy|bevy-embasset|
|---|---|
|0.6|main|
