use super::draw::DrawCuboids;
use super::prepare::BufferCache;

use bevy::prelude::*;
use bevy::render::render_phase::{
    DrawFunctionId, DrawFunctions, EntityPhaseItem, PhaseItem, RenderPhase,
};

pub(crate) fn queue_cuboids(
    opaque_3d_draw_functions: Res<DrawFunctions<CuboidsPhaseItem>>,
    buffer_cache: Res<BufferCache>,
    mut views: Query<&mut RenderPhase<CuboidsPhaseItem>>,
) {
    let draw_cuboids = opaque_3d_draw_functions
        .read()
        .get_id::<DrawCuboids>()
        .unwrap();

    for mut opaque_phase in views.iter_mut() {
        for &entity in buffer_cache.entities() {
            opaque_phase.add(CuboidsPhaseItem {
                entity,
                draw_function: draw_cuboids,
            });
        }
    }
}

pub(crate) struct CuboidsPhaseItem {
    entity: Entity,
    pub(crate) draw_function: DrawFunctionId,
}

impl PhaseItem for CuboidsPhaseItem {
    type SortKey = u32;

    #[inline]
    fn sort_key(&self) -> Self::SortKey {
        0
    }

    #[inline]
    fn draw_function(&self) -> DrawFunctionId {
        self.draw_function
    }
}

impl EntityPhaseItem for CuboidsPhaseItem {
    #[inline]
    fn entity(&self) -> Entity {
        self.entity
    }
}
