//! Render millions of AABBs every frame with an instancing renderer.
//!
//! ![Example
//! Torus](https://raw.githubusercontent.com/ForesightMiningSoftwareCorporation/BVHRenderer_Bevy/main/bevy-aabb-instancing/torus_cubes.png)
//!
//! # Plugins
//!
//! Two render plugins are provided.
//!
//! The [`InstancingRenderPlugin`] does what you might call "canonical" mesh instancing. It does a single instanced draw call
//! per [`Cuboids`] entity by "pushing" vertices through the shader pipeline. **Current limitation**: You must spawn your
//! entities with a [`CuboidInstancesBundle`] for this plugin to work.
//!
//! The [`VertexPullingRenderPlugin`] uses the "vertex pulling" technique to render all entities with a [`Cuboids`] component.
//! In vertex pulling, rather than pushing vertex attributes through the shader pipeline, you only push an index buffer, and the
//! shader "pulls" your instance data from a storage buffer by decoding the `vertex_index` input.
//!
//! The [`VertexPullingRenderPlugin`] can be significantly faster, but it also depends on your platform. Benchmark for yourself.

mod component;
mod instancing;
mod vertex_pulling;

pub use component::*;
pub use instancing::bundle::*;
pub use instancing::plugin::*;
pub use vertex_pulling::plugin::*;

// Re-exports.
pub use bevy;
pub use bitvec;
