use bevy::prelude::*;
use bevy::render::{render_component::ExtractComponent, render_resource::*};

#[derive(Clone, Component, Debug)]
pub(crate) struct CuboidsBuffer {
    pub buffer: Buffer,
    pub length: usize,
}

impl ExtractComponent for CuboidsBuffer {
    type Query = &'static CuboidsBuffer;
    type Filter = ();

    fn extract_component(buffer: bevy::ecs::query::QueryItem<Self::Query>) -> Self {
        buffer.clone()
    }
}
