
#[test]
fn test_public_struct() {

    mod tehn_test {
        use best_macros::*;

        #[public_struct]
        #[derive(Debug)]
        struct HelloWorld {
            text: String,
            number: i32,
        }

        impl HelloWorld {
            pub fn new(a: i32) -> HelloWorld {
                let string = String::from("ekhwfvuw");
                HelloWorld {
                    text: string,
                    number: a,
                }
            }
        }
    }

    let hello_world = tehn_test::HelloWorld::new(12);

    println!("{:?}", hello_world);

    assert_eq!("ekhwfvuw", hello_world.text);
    assert_eq!(12, hello_world.number);
}