use bergwerk::*;
use commands::Command;
use structopt::StructOpt;

#[derive(Debug, StructOpt)]
#[structopt(name = "bergwerk", author, about)]
enum Application {
    /// Creates a new snapshot of the given files and/or directories
    Backup(commands::BackupCommand),
}

impl Application {
    fn run(&self) -> bool {
        return match self {
            Self::Backup(cmd) => cmd.run(),
        };
    }
}

fn main() {
    let app = Application::from_args();

    app.run();
}
